package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class DescribeSourceServersResponse(
    items: Optional[Iterable[zio.aws.mgn.model.SourceServer]] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse = {
    import DescribeSourceServersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DescribeSourceServersResponse.ReadOnly =
    zio.aws.mgn.model.DescribeSourceServersResponse.wrap(buildAwsValue())
}
object DescribeSourceServersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DescribeSourceServersResponse =
      zio.aws.mgn.model.DescribeSourceServersResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[zio.aws.mgn.model.SourceServer.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.mgn.model.SourceServer.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse
  ) extends zio.aws.mgn.model.DescribeSourceServersResponse.ReadOnly {
    override val items
        : Optional[List[zio.aws.mgn.model.SourceServer.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mgn.model.SourceServer.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse
  ): zio.aws.mgn.model.DescribeSourceServersResponse.ReadOnly = new Wrapper(
    impl
  )
}
