package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  LargeBoundedString,
  BoundedString,
  PositiveInteger,
  WaveID,
  SourceServerID,
  ApplicationID
}
import scala.jdk.CollectionConverters._
final case class ImportErrorData(
    applicationID: Optional[ApplicationID] = Optional.Absent,
    ec2LaunchTemplateID: Optional[BoundedString] = Optional.Absent,
    rawError: Optional[LargeBoundedString] = Optional.Absent,
    rowNumber: Optional[PositiveInteger] = Optional.Absent,
    sourceServerID: Optional[SourceServerID] = Optional.Absent,
    waveID: Optional[WaveID] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ImportErrorData = {
    import ImportErrorData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ImportErrorData
      .builder()
      .optionallyWith(
        applicationID.map(value =>
          ApplicationID.unwrap(value): java.lang.String
        )
      )(_.applicationID)
      .optionallyWith(
        ec2LaunchTemplateID.map(value =>
          BoundedString.unwrap(value): java.lang.String
        )
      )(_.ec2LaunchTemplateID)
      .optionallyWith(
        rawError.map(value =>
          LargeBoundedString.unwrap(value): java.lang.String
        )
      )(_.rawError)
      .optionallyWith(
        rowNumber.map(value => PositiveInteger.unwrap(value): java.lang.Long)
      )(_.rowNumber)
      .optionallyWith(
        sourceServerID.map(value =>
          SourceServerID.unwrap(value): java.lang.String
        )
      )(_.sourceServerID)
      .optionallyWith(
        waveID.map(value => WaveID.unwrap(value): java.lang.String)
      )(_.waveID)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ImportErrorData.ReadOnly =
    zio.aws.mgn.model.ImportErrorData.wrap(buildAwsValue())
}
object ImportErrorData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ImportErrorData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ImportErrorData =
      zio.aws.mgn.model.ImportErrorData(
        applicationID.map(value => value),
        ec2LaunchTemplateID.map(value => value),
        rawError.map(value => value),
        rowNumber.map(value => value),
        sourceServerID.map(value => value),
        waveID.map(value => value)
      )
    def applicationID: Optional[ApplicationID]
    def ec2LaunchTemplateID: Optional[BoundedString]
    def rawError: Optional[LargeBoundedString]
    def rowNumber: Optional[PositiveInteger]
    def sourceServerID: Optional[SourceServerID]
    def waveID: Optional[WaveID]
    def getApplicationID: ZIO[Any, AwsError, ApplicationID] =
      AwsError.unwrapOptionField("applicationID", applicationID)
    def getEc2LaunchTemplateID: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("ec2LaunchTemplateID", ec2LaunchTemplateID)
    def getRawError: ZIO[Any, AwsError, LargeBoundedString] =
      AwsError.unwrapOptionField("rawError", rawError)
    def getRowNumber: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("rowNumber", rowNumber)
    def getSourceServerID: ZIO[Any, AwsError, SourceServerID] =
      AwsError.unwrapOptionField("sourceServerID", sourceServerID)
    def getWaveID: ZIO[Any, AwsError, WaveID] =
      AwsError.unwrapOptionField("waveID", waveID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ImportErrorData
  ) extends zio.aws.mgn.model.ImportErrorData.ReadOnly {
    override val applicationID: Optional[ApplicationID] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationID())
      .map(value => zio.aws.mgn.model.primitives.ApplicationID(value))
    override val ec2LaunchTemplateID: Optional[BoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2LaunchTemplateID())
        .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val rawError: Optional[LargeBoundedString] = zio.aws.core.internal
      .optionalFromNullable(impl.rawError())
      .map(value => zio.aws.mgn.model.primitives.LargeBoundedString(value))
    override val rowNumber: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.rowNumber())
      .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val sourceServerID: Optional[SourceServerID] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceServerID())
        .map(value => zio.aws.mgn.model.primitives.SourceServerID(value))
    override val waveID: Optional[WaveID] = zio.aws.core.internal
      .optionalFromNullable(impl.waveID())
      .map(value => zio.aws.mgn.model.primitives.WaveID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ImportErrorData
  ): zio.aws.mgn.model.ImportErrorData.ReadOnly = new Wrapper(impl)
}
