package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.ISO8601DatetimeString
import scala.jdk.CollectionConverters._
final case class ImportTaskError(
    errorData: Optional[zio.aws.mgn.model.ImportErrorData] = Optional.Absent,
    errorDateTime: Optional[ISO8601DatetimeString] = Optional.Absent,
    errorType: Optional[zio.aws.mgn.model.ImportErrorType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ImportTaskError = {
    import ImportTaskError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ImportTaskError
      .builder()
      .optionallyWith(errorData.map(value => value.buildAwsValue()))(
        _.errorData
      )
      .optionallyWith(
        errorDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.errorDateTime)
      .optionallyWith(errorType.map(value => value.unwrap))(_.errorType)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ImportTaskError.ReadOnly =
    zio.aws.mgn.model.ImportTaskError.wrap(buildAwsValue())
}
object ImportTaskError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ImportTaskError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ImportTaskError =
      zio.aws.mgn.model.ImportTaskError(
        errorData.map(value => value.asEditable),
        errorDateTime.map(value => value),
        errorType.map(value => value)
      )
    def errorData: Optional[zio.aws.mgn.model.ImportErrorData.ReadOnly]
    def errorDateTime: Optional[ISO8601DatetimeString]
    def errorType: Optional[zio.aws.mgn.model.ImportErrorType]
    def getErrorData
        : ZIO[Any, AwsError, zio.aws.mgn.model.ImportErrorData.ReadOnly] =
      AwsError.unwrapOptionField("errorData", errorData)
    def getErrorDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("errorDateTime", errorDateTime)
    def getErrorType: ZIO[Any, AwsError, zio.aws.mgn.model.ImportErrorType] =
      AwsError.unwrapOptionField("errorType", errorType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ImportTaskError
  ) extends zio.aws.mgn.model.ImportTaskError.ReadOnly {
    override val errorData
        : Optional[zio.aws.mgn.model.ImportErrorData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorData())
        .map(value => zio.aws.mgn.model.ImportErrorData.wrap(value))
    override val errorDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val errorType: Optional[zio.aws.mgn.model.ImportErrorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorType())
        .map(value => zio.aws.mgn.model.ImportErrorType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ImportTaskError
  ): zio.aws.mgn.model.ImportTaskError.ReadOnly = new Wrapper(impl)
}
