package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportTaskSummary(
    applications: Optional[zio.aws.mgn.model.ImportTaskSummaryApplications] =
      Optional.Absent,
    servers: Optional[zio.aws.mgn.model.ImportTaskSummaryServers] =
      Optional.Absent,
    waves: Optional[zio.aws.mgn.model.ImportTaskSummaryWaves] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ImportTaskSummary = {
    import ImportTaskSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ImportTaskSummary
      .builder()
      .optionallyWith(applications.map(value => value.buildAwsValue()))(
        _.applications
      )
      .optionallyWith(servers.map(value => value.buildAwsValue()))(_.servers)
      .optionallyWith(waves.map(value => value.buildAwsValue()))(_.waves)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ImportTaskSummary.ReadOnly =
    zio.aws.mgn.model.ImportTaskSummary.wrap(buildAwsValue())
}
object ImportTaskSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ImportTaskSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ImportTaskSummary =
      zio.aws.mgn.model.ImportTaskSummary(
        applications.map(value => value.asEditable),
        servers.map(value => value.asEditable),
        waves.map(value => value.asEditable)
      )
    def applications
        : Optional[zio.aws.mgn.model.ImportTaskSummaryApplications.ReadOnly]
    def servers: Optional[zio.aws.mgn.model.ImportTaskSummaryServers.ReadOnly]
    def waves: Optional[zio.aws.mgn.model.ImportTaskSummaryWaves.ReadOnly]
    def getApplications: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.ImportTaskSummaryApplications.ReadOnly
    ] = AwsError.unwrapOptionField("applications", applications)
    def getServers: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.ImportTaskSummaryServers.ReadOnly
    ] = AwsError.unwrapOptionField("servers", servers)
    def getWaves: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.ImportTaskSummaryWaves.ReadOnly
    ] = AwsError.unwrapOptionField("waves", waves)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ImportTaskSummary
  ) extends zio.aws.mgn.model.ImportTaskSummary.ReadOnly {
    override val applications
        : Optional[zio.aws.mgn.model.ImportTaskSummaryApplications.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applications())
        .map(value =>
          zio.aws.mgn.model.ImportTaskSummaryApplications.wrap(value)
        )
    override val servers
        : Optional[zio.aws.mgn.model.ImportTaskSummaryServers.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.servers())
        .map(value => zio.aws.mgn.model.ImportTaskSummaryServers.wrap(value))
    override val waves
        : Optional[zio.aws.mgn.model.ImportTaskSummaryWaves.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.waves())
        .map(value => zio.aws.mgn.model.ImportTaskSummaryWaves.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ImportTaskSummary
  ): zio.aws.mgn.model.ImportTaskSummary.ReadOnly = new Wrapper(impl)
}
