package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.PositiveInteger
import scala.jdk.CollectionConverters._
final case class ImportTaskSummaryServers(
    createdCount: Optional[PositiveInteger] = Optional.Absent,
    modifiedCount: Optional[PositiveInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ImportTaskSummaryServers = {
    import ImportTaskSummaryServers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ImportTaskSummaryServers
      .builder()
      .optionallyWith(
        createdCount.map(value => PositiveInteger.unwrap(value): java.lang.Long)
      )(_.createdCount)
      .optionallyWith(
        modifiedCount.map(value =>
          PositiveInteger.unwrap(value): java.lang.Long
        )
      )(_.modifiedCount)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ImportTaskSummaryServers.ReadOnly =
    zio.aws.mgn.model.ImportTaskSummaryServers.wrap(buildAwsValue())
}
object ImportTaskSummaryServers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ImportTaskSummaryServers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ImportTaskSummaryServers =
      zio.aws.mgn.model.ImportTaskSummaryServers(
        createdCount.map(value => value),
        modifiedCount.map(value => value)
      )
    def createdCount: Optional[PositiveInteger]
    def modifiedCount: Optional[PositiveInteger]
    def getCreatedCount: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("createdCount", createdCount)
    def getModifiedCount: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("modifiedCount", modifiedCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ImportTaskSummaryServers
  ) extends zio.aws.mgn.model.ImportTaskSummaryServers.ReadOnly {
    override val createdCount: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.createdCount())
      .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val modifiedCount: Optional[PositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modifiedCount())
        .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ImportTaskSummaryServers
  ): zio.aws.mgn.model.ImportTaskSummaryServers.ReadOnly = new Wrapper(impl)
}
