package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.PositiveInteger
import scala.jdk.CollectionConverters._
final case class ImportTaskSummaryWaves(
    createdCount: Optional[PositiveInteger] = Optional.Absent,
    modifiedCount: Optional[PositiveInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ImportTaskSummaryWaves = {
    import ImportTaskSummaryWaves.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ImportTaskSummaryWaves
      .builder()
      .optionallyWith(
        createdCount.map(value => PositiveInteger.unwrap(value): java.lang.Long)
      )(_.createdCount)
      .optionallyWith(
        modifiedCount.map(value =>
          PositiveInteger.unwrap(value): java.lang.Long
        )
      )(_.modifiedCount)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ImportTaskSummaryWaves.ReadOnly =
    zio.aws.mgn.model.ImportTaskSummaryWaves.wrap(buildAwsValue())
}
object ImportTaskSummaryWaves {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ImportTaskSummaryWaves
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ImportTaskSummaryWaves =
      zio.aws.mgn.model.ImportTaskSummaryWaves(
        createdCount.map(value => value),
        modifiedCount.map(value => value)
      )
    def createdCount: Optional[PositiveInteger]
    def modifiedCount: Optional[PositiveInteger]
    def getCreatedCount: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("createdCount", createdCount)
    def getModifiedCount: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("modifiedCount", modifiedCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ImportTaskSummaryWaves
  ) extends zio.aws.mgn.model.ImportTaskSummaryWaves.ReadOnly {
    override val createdCount: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.createdCount())
      .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val modifiedCount: Optional[PositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modifiedCount())
        .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ImportTaskSummaryWaves
  ): zio.aws.mgn.model.ImportTaskSummaryWaves.ReadOnly = new Wrapper(impl)
}
