package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LifeCycleLastTest(
    finalized: Optional[zio.aws.mgn.model.LifeCycleLastTestFinalized] =
      Optional.Absent,
    initiated: Optional[zio.aws.mgn.model.LifeCycleLastTestInitiated] =
      Optional.Absent,
    reverted: Optional[zio.aws.mgn.model.LifeCycleLastTestReverted] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.LifeCycleLastTest = {
    import LifeCycleLastTest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.LifeCycleLastTest
      .builder()
      .optionallyWith(finalized.map(value => value.buildAwsValue()))(
        _.finalized
      )
      .optionallyWith(initiated.map(value => value.buildAwsValue()))(
        _.initiated
      )
      .optionallyWith(reverted.map(value => value.buildAwsValue()))(_.reverted)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.LifeCycleLastTest.ReadOnly =
    zio.aws.mgn.model.LifeCycleLastTest.wrap(buildAwsValue())
}
object LifeCycleLastTest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.LifeCycleLastTest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.LifeCycleLastTest =
      zio.aws.mgn.model.LifeCycleLastTest(
        finalized.map(value => value.asEditable),
        initiated.map(value => value.asEditable),
        reverted.map(value => value.asEditable)
      )
    def finalized
        : Optional[zio.aws.mgn.model.LifeCycleLastTestFinalized.ReadOnly]
    def initiated
        : Optional[zio.aws.mgn.model.LifeCycleLastTestInitiated.ReadOnly]
    def reverted: Optional[zio.aws.mgn.model.LifeCycleLastTestReverted.ReadOnly]
    def getFinalized: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.LifeCycleLastTestFinalized.ReadOnly
    ] = AwsError.unwrapOptionField("finalized", finalized)
    def getInitiated: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.LifeCycleLastTestInitiated.ReadOnly
    ] = AwsError.unwrapOptionField("initiated", initiated)
    def getReverted: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.LifeCycleLastTestReverted.ReadOnly
    ] = AwsError.unwrapOptionField("reverted", reverted)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.LifeCycleLastTest
  ) extends zio.aws.mgn.model.LifeCycleLastTest.ReadOnly {
    override val finalized
        : Optional[zio.aws.mgn.model.LifeCycleLastTestFinalized.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finalized())
        .map(value => zio.aws.mgn.model.LifeCycleLastTestFinalized.wrap(value))
    override val initiated
        : Optional[zio.aws.mgn.model.LifeCycleLastTestInitiated.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initiated())
        .map(value => zio.aws.mgn.model.LifeCycleLastTestInitiated.wrap(value))
    override val reverted
        : Optional[zio.aws.mgn.model.LifeCycleLastTestReverted.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reverted())
        .map(value => zio.aws.mgn.model.LifeCycleLastTestReverted.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.LifeCycleLastTest
  ): zio.aws.mgn.model.LifeCycleLastTest.ReadOnly = new Wrapper(impl)
}
