package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.ISO8601DatetimeString
import scala.jdk.CollectionConverters._
final case class LifeCycleLastTestFinalized(
    apiCallDateTime: Optional[ISO8601DatetimeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.LifeCycleLastTestFinalized = {
    import LifeCycleLastTestFinalized.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.LifeCycleLastTestFinalized
      .builder()
      .optionallyWith(
        apiCallDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.apiCallDateTime)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.LifeCycleLastTestFinalized.ReadOnly =
    zio.aws.mgn.model.LifeCycleLastTestFinalized.wrap(buildAwsValue())
}
object LifeCycleLastTestFinalized {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.LifeCycleLastTestFinalized
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.LifeCycleLastTestFinalized =
      zio.aws.mgn.model
        .LifeCycleLastTestFinalized(apiCallDateTime.map(value => value))
    def apiCallDateTime: Optional[ISO8601DatetimeString]
    def getApiCallDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("apiCallDateTime", apiCallDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.LifeCycleLastTestFinalized
  ) extends zio.aws.mgn.model.LifeCycleLastTestFinalized.ReadOnly {
    override val apiCallDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiCallDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.LifeCycleLastTestFinalized
  ): zio.aws.mgn.model.LifeCycleLastTestFinalized.ReadOnly = new Wrapper(impl)
}
