package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.ExportID
import scala.jdk.CollectionConverters._
final case class ListExportsRequestFilters(
    exportIDs: Optional[Iterable[ExportID]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ListExportsRequestFilters = {
    import ListExportsRequestFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ListExportsRequestFilters
      .builder()
      .optionallyWith(
        exportIDs.map(value =>
          value.map { item =>
            ExportID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.exportIDs)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ListExportsRequestFilters.ReadOnly =
    zio.aws.mgn.model.ListExportsRequestFilters.wrap(buildAwsValue())
}
object ListExportsRequestFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ListExportsRequestFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ListExportsRequestFilters =
      zio.aws.mgn.model.ListExportsRequestFilters(exportIDs.map(value => value))
    def exportIDs: Optional[List[ExportID]]
    def getExportIDs: ZIO[Any, AwsError, List[ExportID]] =
      AwsError.unwrapOptionField("exportIDs", exportIDs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ListExportsRequestFilters
  ) extends zio.aws.mgn.model.ListExportsRequestFilters.ReadOnly {
    override val exportIDs: Optional[List[ExportID]] = zio.aws.core.internal
      .optionalFromNullable(impl.exportIDs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.primitives.ExportID(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ListExportsRequestFilters
  ): zio.aws.mgn.model.ListExportsRequestFilters.ReadOnly = new Wrapper(impl)
}
