package zio.aws.mgn.model
import zio.aws.mgn.model.primitives.{
  StrictlyPositiveInteger,
  SsmDocumentName,
  SsmDocumentParameterName,
  BoundedString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SsmDocument(
    actionName: BoundedString,
    externalParameters: Optional[
      Map[SsmDocumentParameterName, zio.aws.mgn.model.SsmExternalParameter]
    ] = Optional.Absent,
    mustSucceedForCutover: Optional[Boolean] = Optional.Absent,
    parameters: Optional[Map[SsmDocumentParameterName, Iterable[
      zio.aws.mgn.model.SsmParameterStoreParameter
    ]]] = Optional.Absent,
    ssmDocumentName: SsmDocumentName,
    timeoutSeconds: Optional[StrictlyPositiveInteger] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.mgn.model.SsmDocument = {
    import SsmDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.SsmDocument
      .builder()
      .actionName(BoundedString.unwrap(actionName): java.lang.String)
      .optionallyWith(
        externalParameters.map(value =>
          value
            .map({ case (key, value) =>
              (SsmDocumentParameterName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.externalParameters)
      .optionallyWith(
        mustSucceedForCutover.map(value => value: java.lang.Boolean)
      )(_.mustSucceedForCutover)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (SsmDocumentParameterName.unwrap(
                key
              ): java.lang.String) -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .ssmDocumentName(
        SsmDocumentName.unwrap(ssmDocumentName): java.lang.String
      )
      .optionallyWith(
        timeoutSeconds.map(value =>
          StrictlyPositiveInteger.unwrap(value): Integer
        )
      )(_.timeoutSeconds)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.SsmDocument.ReadOnly =
    zio.aws.mgn.model.SsmDocument.wrap(buildAwsValue())
}
object SsmDocument {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mgn.model.SsmDocument] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.SsmDocument =
      zio.aws.mgn.model.SsmDocument(
        actionName,
        externalParameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        mustSucceedForCutover.map(value => value),
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        ssmDocumentName,
        timeoutSeconds.map(value => value)
      )
    def actionName: BoundedString
    def externalParameters: Optional[Map[
      SsmDocumentParameterName,
      zio.aws.mgn.model.SsmExternalParameter.ReadOnly
    ]]
    def mustSucceedForCutover: Optional[Boolean]
    def parameters: Optional[Map[SsmDocumentParameterName, List[
      zio.aws.mgn.model.SsmParameterStoreParameter.ReadOnly
    ]]]
    def ssmDocumentName: SsmDocumentName
    def timeoutSeconds: Optional[StrictlyPositiveInteger]
    def getActionName: ZIO[Any, Nothing, BoundedString] =
      ZIO.succeed(actionName)
    def getExternalParameters: ZIO[Any, AwsError, Map[
      SsmDocumentParameterName,
      zio.aws.mgn.model.SsmExternalParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("externalParameters", externalParameters)
    def getMustSucceedForCutover: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("mustSucceedForCutover", mustSucceedForCutover)
    def getParameters: ZIO[Any, AwsError, Map[SsmDocumentParameterName, List[
      zio.aws.mgn.model.SsmParameterStoreParameter.ReadOnly
    ]]] = AwsError.unwrapOptionField("parameters", parameters)
    def getSsmDocumentName: ZIO[Any, Nothing, SsmDocumentName] =
      ZIO.succeed(ssmDocumentName)
    def getTimeoutSeconds: ZIO[Any, AwsError, StrictlyPositiveInteger] =
      AwsError.unwrapOptionField("timeoutSeconds", timeoutSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.SsmDocument
  ) extends zio.aws.mgn.model.SsmDocument.ReadOnly {
    override val actionName: BoundedString =
      zio.aws.mgn.model.primitives.BoundedString(impl.actionName())
    override val externalParameters: Optional[Map[
      SsmDocumentParameterName,
      zio.aws.mgn.model.SsmExternalParameter.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.externalParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives.SsmDocumentParameterName(
              key
            ) -> zio.aws.mgn.model.SsmExternalParameter.wrap(value)
          })
          .toMap
      )
    override val mustSucceedForCutover: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mustSucceedForCutover())
        .map(value => value: Boolean)
    override val parameters: Optional[Map[SsmDocumentParameterName, List[
      zio.aws.mgn.model.SsmParameterStoreParameter.ReadOnly
    ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .SsmDocumentParameterName(key) -> value.asScala.map { item =>
              zio.aws.mgn.model.SsmParameterStoreParameter.wrap(item)
            }.toList
          })
          .toMap
      )
    override val ssmDocumentName: SsmDocumentName =
      zio.aws.mgn.model.primitives.SsmDocumentName(impl.ssmDocumentName())
    override val timeoutSeconds: Optional[StrictlyPositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutSeconds())
        .map(value =>
          zio.aws.mgn.model.primitives.StrictlyPositiveInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.SsmDocument
  ): zio.aws.mgn.model.SsmDocument.ReadOnly = new Wrapper(impl)
}
