package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartExportResponse(
    exportTask: Optional[zio.aws.mgn.model.ExportTask] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.StartExportResponse = {
    import StartExportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.StartExportResponse
      .builder()
      .optionallyWith(exportTask.map(value => value.buildAwsValue()))(
        _.exportTask
      )
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.StartExportResponse.ReadOnly =
    zio.aws.mgn.model.StartExportResponse.wrap(buildAwsValue())
}
object StartExportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.StartExportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.StartExportResponse = zio.aws.mgn.model
      .StartExportResponse(exportTask.map(value => value.asEditable))
    def exportTask: Optional[zio.aws.mgn.model.ExportTask.ReadOnly]
    def getExportTask
        : ZIO[Any, AwsError, zio.aws.mgn.model.ExportTask.ReadOnly] =
      AwsError.unwrapOptionField("exportTask", exportTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.StartExportResponse
  ) extends zio.aws.mgn.model.StartExportResponse.ReadOnly {
    override val exportTask: Optional[zio.aws.mgn.model.ExportTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportTask())
        .map(value => zio.aws.mgn.model.ExportTask.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.StartExportResponse
  ): zio.aws.mgn.model.StartExportResponse.ReadOnly = new Wrapper(impl)
}
