package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.ActionID
import scala.jdk.CollectionConverters._
final case class TemplateActionsRequestFilters(
    actionIDs: Optional[Iterable[ActionID]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.TemplateActionsRequestFilters = {
    import TemplateActionsRequestFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.TemplateActionsRequestFilters
      .builder()
      .optionallyWith(
        actionIDs.map(value =>
          value.map { item =>
            ActionID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.actionIDs)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.TemplateActionsRequestFilters.ReadOnly =
    zio.aws.mgn.model.TemplateActionsRequestFilters.wrap(buildAwsValue())
}
object TemplateActionsRequestFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.TemplateActionsRequestFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.TemplateActionsRequestFilters =
      zio.aws.mgn.model
        .TemplateActionsRequestFilters(actionIDs.map(value => value))
    def actionIDs: Optional[List[ActionID]]
    def getActionIDs: ZIO[Any, AwsError, List[ActionID]] =
      AwsError.unwrapOptionField("actionIDs", actionIDs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.TemplateActionsRequestFilters
  ) extends zio.aws.mgn.model.TemplateActionsRequestFilters.ReadOnly {
    override val actionIDs: Optional[List[ActionID]] = zio.aws.core.internal
      .optionalFromNullable(impl.actionIDs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.primitives.ActionID(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.TemplateActionsRequestFilters
  ): zio.aws.mgn.model.TemplateActionsRequestFilters.ReadOnly = new Wrapper(
    impl
  )
}
