package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  ApplicationName,
  ApplicationDescription,
  ApplicationID
}
import scala.jdk.CollectionConverters._
final case class UpdateApplicationRequest(
    applicationID: ApplicationID,
    description: Optional[ApplicationDescription] = Optional.Absent,
    name: Optional[ApplicationName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.UpdateApplicationRequest = {
    import UpdateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.UpdateApplicationRequest
      .builder()
      .applicationID(ApplicationID.unwrap(applicationID): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ApplicationDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        name.map(value => ApplicationName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.UpdateApplicationRequest.ReadOnly =
    zio.aws.mgn.model.UpdateApplicationRequest.wrap(buildAwsValue())
}
object UpdateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.UpdateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.UpdateApplicationRequest =
      zio.aws.mgn.model.UpdateApplicationRequest(
        applicationID,
        description.map(value => value),
        name.map(value => value)
      )
    def applicationID: ApplicationID
    def description: Optional[ApplicationDescription]
    def name: Optional[ApplicationName]
    def getApplicationID: ZIO[Any, Nothing, ApplicationID] =
      ZIO.succeed(applicationID)
    def getDescription: ZIO[Any, AwsError, ApplicationDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.UpdateApplicationRequest
  ) extends zio.aws.mgn.model.UpdateApplicationRequest.ReadOnly {
    override val applicationID: ApplicationID =
      zio.aws.mgn.model.primitives.ApplicationID(impl.applicationID())
    override val description: Optional[ApplicationDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.mgn.model.primitives.ApplicationDescription(value)
        )
    override val name: Optional[ApplicationName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.mgn.model.primitives.ApplicationName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.UpdateApplicationRequest
  ): zio.aws.mgn.model.UpdateApplicationRequest.ReadOnly = new Wrapper(impl)
}
