package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait ActionCategory {
  def unwrap: software.amazon.awssdk.services.mgn.model.ActionCategory
}
object ActionCategory {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.ActionCategory
  ): zio.aws.mgn.model.ActionCategory = value match {
    case software.amazon.awssdk.services.mgn.model.ActionCategory.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.ActionCategory.DISASTER_RECOVERY =>
      val r = DISASTER_RECOVERY
      r
    case software.amazon.awssdk.services.mgn.model.ActionCategory.OPERATING_SYSTEM =>
      val r = OPERATING_SYSTEM
      r
    case software.amazon.awssdk.services.mgn.model.ActionCategory.LICENSE_AND_SUBSCRIPTION =>
      val r = LICENSE_AND_SUBSCRIPTION
      r
    case software.amazon.awssdk.services.mgn.model.ActionCategory.VALIDATION =>
      val r = VALIDATION
      r
    case software.amazon.awssdk.services.mgn.model.ActionCategory.OBSERVABILITY =>
      val r = OBSERVABILITY
      r
    case software.amazon.awssdk.services.mgn.model.ActionCategory.REFACTORING =>
      val r = REFACTORING
      r
    case software.amazon.awssdk.services.mgn.model.ActionCategory.SECURITY =>
      val r = SECURITY
      r
    case software.amazon.awssdk.services.mgn.model.ActionCategory.NETWORKING =>
      val r = NETWORKING
      r
    case software.amazon.awssdk.services.mgn.model.ActionCategory.CONFIGURATION =>
      val r = CONFIGURATION
      r
    case software.amazon.awssdk.services.mgn.model.ActionCategory.BACKUP =>
      val r = BACKUP
      r
    case software.amazon.awssdk.services.mgn.model.ActionCategory.OTHER =>
      val r = OTHER
      r
  }
  case object unknownToSdkVersion extends zio.aws.mgn.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ActionCategory =
      software.amazon.awssdk.services.mgn.model.ActionCategory.UNKNOWN_TO_SDK_VERSION
  }
  case object DISASTER_RECOVERY extends zio.aws.mgn.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ActionCategory =
      software.amazon.awssdk.services.mgn.model.ActionCategory.DISASTER_RECOVERY
  }
  case object OPERATING_SYSTEM extends zio.aws.mgn.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ActionCategory =
      software.amazon.awssdk.services.mgn.model.ActionCategory.OPERATING_SYSTEM
  }
  case object LICENSE_AND_SUBSCRIPTION
      extends zio.aws.mgn.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ActionCategory =
      software.amazon.awssdk.services.mgn.model.ActionCategory.LICENSE_AND_SUBSCRIPTION
  }
  case object VALIDATION extends zio.aws.mgn.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ActionCategory =
      software.amazon.awssdk.services.mgn.model.ActionCategory.VALIDATION
  }
  case object OBSERVABILITY extends zio.aws.mgn.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ActionCategory =
      software.amazon.awssdk.services.mgn.model.ActionCategory.OBSERVABILITY
  }
  case object REFACTORING extends zio.aws.mgn.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ActionCategory =
      software.amazon.awssdk.services.mgn.model.ActionCategory.REFACTORING
  }
  case object SECURITY extends zio.aws.mgn.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ActionCategory =
      software.amazon.awssdk.services.mgn.model.ActionCategory.SECURITY
  }
  case object NETWORKING extends zio.aws.mgn.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ActionCategory =
      software.amazon.awssdk.services.mgn.model.ActionCategory.NETWORKING
  }
  case object CONFIGURATION extends zio.aws.mgn.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ActionCategory =
      software.amazon.awssdk.services.mgn.model.ActionCategory.CONFIGURATION
  }
  case object BACKUP extends zio.aws.mgn.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ActionCategory =
      software.amazon.awssdk.services.mgn.model.ActionCategory.BACKUP
  }
  case object OTHER extends zio.aws.mgn.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ActionCategory =
      software.amazon.awssdk.services.mgn.model.ActionCategory.OTHER
  }
}
