package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{PositiveInteger, ISO8601DatetimeString}
import scala.jdk.CollectionConverters._
final case class ApplicationAggregatedStatus(
    healthStatus: Optional[zio.aws.mgn.model.ApplicationHealthStatus] =
      Optional.Absent,
    lastUpdateDateTime: Optional[ISO8601DatetimeString] = Optional.Absent,
    progressStatus: Optional[zio.aws.mgn.model.ApplicationProgressStatus] =
      Optional.Absent,
    totalSourceServers: Optional[PositiveInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ApplicationAggregatedStatus = {
    import ApplicationAggregatedStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ApplicationAggregatedStatus
      .builder()
      .optionallyWith(healthStatus.map(value => value.unwrap))(_.healthStatus)
      .optionallyWith(
        lastUpdateDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.lastUpdateDateTime)
      .optionallyWith(progressStatus.map(value => value.unwrap))(
        _.progressStatus
      )
      .optionallyWith(
        totalSourceServers.map(value =>
          PositiveInteger.unwrap(value): java.lang.Long
        )
      )(_.totalSourceServers)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ApplicationAggregatedStatus.ReadOnly =
    zio.aws.mgn.model.ApplicationAggregatedStatus.wrap(buildAwsValue())
}
object ApplicationAggregatedStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ApplicationAggregatedStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ApplicationAggregatedStatus =
      zio.aws.mgn.model.ApplicationAggregatedStatus(
        healthStatus.map(value => value),
        lastUpdateDateTime.map(value => value),
        progressStatus.map(value => value),
        totalSourceServers.map(value => value)
      )
    def healthStatus: Optional[zio.aws.mgn.model.ApplicationHealthStatus]
    def lastUpdateDateTime: Optional[ISO8601DatetimeString]
    def progressStatus: Optional[zio.aws.mgn.model.ApplicationProgressStatus]
    def totalSourceServers: Optional[PositiveInteger]
    def getHealthStatus
        : ZIO[Any, AwsError, zio.aws.mgn.model.ApplicationHealthStatus] =
      AwsError.unwrapOptionField("healthStatus", healthStatus)
    def getLastUpdateDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("lastUpdateDateTime", lastUpdateDateTime)
    def getProgressStatus
        : ZIO[Any, AwsError, zio.aws.mgn.model.ApplicationProgressStatus] =
      AwsError.unwrapOptionField("progressStatus", progressStatus)
    def getTotalSourceServers: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("totalSourceServers", totalSourceServers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ApplicationAggregatedStatus
  ) extends zio.aws.mgn.model.ApplicationAggregatedStatus.ReadOnly {
    override val healthStatus
        : Optional[zio.aws.mgn.model.ApplicationHealthStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthStatus())
        .map(value => zio.aws.mgn.model.ApplicationHealthStatus.wrap(value))
    override val lastUpdateDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val progressStatus
        : Optional[zio.aws.mgn.model.ApplicationProgressStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressStatus())
        .map(value => zio.aws.mgn.model.ApplicationProgressStatus.wrap(value))
    override val totalSourceServers: Optional[PositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalSourceServers())
        .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ApplicationAggregatedStatus
  ): zio.aws.mgn.model.ApplicationAggregatedStatus.ReadOnly = new Wrapper(impl)
}
