package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{WaveID, ApplicationID, AccountID}
import scala.jdk.CollectionConverters._
final case class AssociateApplicationsRequest(
    accountID: Optional[AccountID] = Optional.Absent,
    applicationIDs: Iterable[ApplicationID],
    waveID: WaveID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.AssociateApplicationsRequest = {
    import AssociateApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.AssociateApplicationsRequest
      .builder()
      .optionallyWith(
        accountID.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.accountID)
      .applicationIDs(applicationIDs.map { item =>
        ApplicationID.unwrap(item): java.lang.String
      }.asJavaCollection)
      .waveID(WaveID.unwrap(waveID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.AssociateApplicationsRequest.ReadOnly =
    zio.aws.mgn.model.AssociateApplicationsRequest.wrap(buildAwsValue())
}
object AssociateApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.AssociateApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.AssociateApplicationsRequest =
      zio.aws.mgn.model.AssociateApplicationsRequest(
        accountID.map(value => value),
        applicationIDs,
        waveID
      )
    def accountID: Optional[AccountID]
    def applicationIDs: List[ApplicationID]
    def waveID: WaveID
    def getAccountID: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("accountID", accountID)
    def getApplicationIDs: ZIO[Any, Nothing, List[ApplicationID]] =
      ZIO.succeed(applicationIDs)
    def getWaveID: ZIO[Any, Nothing, WaveID] = ZIO.succeed(waveID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.AssociateApplicationsRequest
  ) extends zio.aws.mgn.model.AssociateApplicationsRequest.ReadOnly {
    override val accountID: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.accountID())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val applicationIDs: List[ApplicationID] = impl
      .applicationIDs()
      .asScala
      .map { item =>
        zio.aws.mgn.model.primitives.ApplicationID(item)
      }
      .toList
    override val waveID: WaveID =
      zio.aws.mgn.model.primitives.WaveID(impl.waveID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.AssociateApplicationsRequest
  ): zio.aws.mgn.model.AssociateApplicationsRequest.ReadOnly = new Wrapper(impl)
}
