package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{SourceServerID, ApplicationID, AccountID}
import scala.jdk.CollectionConverters._
final case class AssociateSourceServersRequest(
    accountID: Optional[AccountID] = Optional.Absent,
    applicationID: ApplicationID,
    sourceServerIDs: Iterable[SourceServerID]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.AssociateSourceServersRequest = {
    import AssociateSourceServersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.AssociateSourceServersRequest
      .builder()
      .optionallyWith(
        accountID.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.accountID)
      .applicationID(ApplicationID.unwrap(applicationID): java.lang.String)
      .sourceServerIDs(sourceServerIDs.map { item =>
        SourceServerID.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.AssociateSourceServersRequest.ReadOnly =
    zio.aws.mgn.model.AssociateSourceServersRequest.wrap(buildAwsValue())
}
object AssociateSourceServersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.AssociateSourceServersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.AssociateSourceServersRequest =
      zio.aws.mgn.model.AssociateSourceServersRequest(
        accountID.map(value => value),
        applicationID,
        sourceServerIDs
      )
    def accountID: Optional[AccountID]
    def applicationID: ApplicationID
    def sourceServerIDs: List[SourceServerID]
    def getAccountID: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("accountID", accountID)
    def getApplicationID: ZIO[Any, Nothing, ApplicationID] =
      ZIO.succeed(applicationID)
    def getSourceServerIDs: ZIO[Any, Nothing, List[SourceServerID]] =
      ZIO.succeed(sourceServerIDs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.AssociateSourceServersRequest
  ) extends zio.aws.mgn.model.AssociateSourceServersRequest.ReadOnly {
    override val accountID: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.accountID())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val applicationID: ApplicationID =
      zio.aws.mgn.model.primitives.ApplicationID(impl.applicationID())
    override val sourceServerIDs: List[SourceServerID] = impl
      .sourceServerIDs()
      .asScala
      .map { item =>
        zio.aws.mgn.model.primitives.SourceServerID(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.AssociateSourceServersRequest
  ): zio.aws.mgn.model.AssociateSourceServersRequest.ReadOnly = new Wrapper(
    impl
  )
}
