package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait BootMode {
  def unwrap: software.amazon.awssdk.services.mgn.model.BootMode
}
object BootMode {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.BootMode
  ): zio.aws.mgn.model.BootMode = value match {
    case software.amazon.awssdk.services.mgn.model.BootMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.BootMode.LEGACY_BIOS =>
      val r = LEGACY_BIOS
      r
    case software.amazon.awssdk.services.mgn.model.BootMode.UEFI =>
      val r = UEFI
      r
    case software.amazon.awssdk.services.mgn.model.BootMode.USE_SOURCE =>
      val r = USE_SOURCE
      r
  }
  case object unknownToSdkVersion extends zio.aws.mgn.model.BootMode {
    override def unwrap: software.amazon.awssdk.services.mgn.model.BootMode =
      software.amazon.awssdk.services.mgn.model.BootMode.UNKNOWN_TO_SDK_VERSION
  }
  case object LEGACY_BIOS extends zio.aws.mgn.model.BootMode {
    override def unwrap: software.amazon.awssdk.services.mgn.model.BootMode =
      software.amazon.awssdk.services.mgn.model.BootMode.LEGACY_BIOS
  }
  case object UEFI extends zio.aws.mgn.model.BootMode {
    override def unwrap: software.amazon.awssdk.services.mgn.model.BootMode =
      software.amazon.awssdk.services.mgn.model.BootMode.UEFI
  }
  case object USE_SOURCE extends zio.aws.mgn.model.BootMode {
    override def unwrap: software.amazon.awssdk.services.mgn.model.BootMode =
      software.amazon.awssdk.services.mgn.model.BootMode.USE_SOURCE
  }
}
