package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  TagValue,
  TagKey,
  SsmInstanceID,
  ConnectorName
}
import scala.jdk.CollectionConverters._
final case class CreateConnectorRequest(
    name: ConnectorName,
    ssmCommandConfig: Optional[zio.aws.mgn.model.ConnectorSsmCommandConfig] =
      Optional.Absent,
    ssmInstanceID: SsmInstanceID,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.CreateConnectorRequest = {
    import CreateConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.CreateConnectorRequest
      .builder()
      .name(ConnectorName.unwrap(name): java.lang.String)
      .optionallyWith(ssmCommandConfig.map(value => value.buildAwsValue()))(
        _.ssmCommandConfig
      )
      .ssmInstanceID(SsmInstanceID.unwrap(ssmInstanceID): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.CreateConnectorRequest.ReadOnly =
    zio.aws.mgn.model.CreateConnectorRequest.wrap(buildAwsValue())
}
object CreateConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.CreateConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.CreateConnectorRequest =
      zio.aws.mgn.model.CreateConnectorRequest(
        name,
        ssmCommandConfig.map(value => value.asEditable),
        ssmInstanceID,
        tags.map(value => value)
      )
    def name: ConnectorName
    def ssmCommandConfig
        : Optional[zio.aws.mgn.model.ConnectorSsmCommandConfig.ReadOnly]
    def ssmInstanceID: SsmInstanceID
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, ConnectorName] = ZIO.succeed(name)
    def getSsmCommandConfig: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.ConnectorSsmCommandConfig.ReadOnly
    ] = AwsError.unwrapOptionField("ssmCommandConfig", ssmCommandConfig)
    def getSsmInstanceID: ZIO[Any, Nothing, SsmInstanceID] =
      ZIO.succeed(ssmInstanceID)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.CreateConnectorRequest
  ) extends zio.aws.mgn.model.CreateConnectorRequest.ReadOnly {
    override val name: ConnectorName =
      zio.aws.mgn.model.primitives.ConnectorName(impl.name())
    override val ssmCommandConfig
        : Optional[zio.aws.mgn.model.ConnectorSsmCommandConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ssmCommandConfig())
        .map(value => zio.aws.mgn.model.ConnectorSsmCommandConfig.wrap(value))
    override val ssmInstanceID: SsmInstanceID =
      zio.aws.mgn.model.primitives.SsmInstanceID(impl.ssmInstanceID())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.CreateConnectorRequest
  ): zio.aws.mgn.model.CreateConnectorRequest.ReadOnly = new Wrapper(impl)
}
