package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  SsmInstanceID,
  TagValue,
  ConnectorName,
  ConnectorID,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateConnectorResponse(
    arn: Optional[ARN] = Optional.Absent,
    connectorID: Optional[ConnectorID] = Optional.Absent,
    name: Optional[ConnectorName] = Optional.Absent,
    ssmCommandConfig: Optional[zio.aws.mgn.model.ConnectorSsmCommandConfig] =
      Optional.Absent,
    ssmInstanceID: Optional[SsmInstanceID] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.CreateConnectorResponse = {
    import CreateConnectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.CreateConnectorResponse
      .builder()
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        connectorID.map(value => ConnectorID.unwrap(value): java.lang.String)
      )(_.connectorID)
      .optionallyWith(
        name.map(value => ConnectorName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(ssmCommandConfig.map(value => value.buildAwsValue()))(
        _.ssmCommandConfig
      )
      .optionallyWith(
        ssmInstanceID.map(value =>
          SsmInstanceID.unwrap(value): java.lang.String
        )
      )(_.ssmInstanceID)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.CreateConnectorResponse.ReadOnly =
    zio.aws.mgn.model.CreateConnectorResponse.wrap(buildAwsValue())
}
object CreateConnectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.CreateConnectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.CreateConnectorResponse =
      zio.aws.mgn.model.CreateConnectorResponse(
        arn.map(value => value),
        connectorID.map(value => value),
        name.map(value => value),
        ssmCommandConfig.map(value => value.asEditable),
        ssmInstanceID.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[ARN]
    def connectorID: Optional[ConnectorID]
    def name: Optional[ConnectorName]
    def ssmCommandConfig
        : Optional[zio.aws.mgn.model.ConnectorSsmCommandConfig.ReadOnly]
    def ssmInstanceID: Optional[SsmInstanceID]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getConnectorID: ZIO[Any, AwsError, ConnectorID] =
      AwsError.unwrapOptionField("connectorID", connectorID)
    def getName: ZIO[Any, AwsError, ConnectorName] =
      AwsError.unwrapOptionField("name", name)
    def getSsmCommandConfig: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.ConnectorSsmCommandConfig.ReadOnly
    ] = AwsError.unwrapOptionField("ssmCommandConfig", ssmCommandConfig)
    def getSsmInstanceID: ZIO[Any, AwsError, SsmInstanceID] =
      AwsError.unwrapOptionField("ssmInstanceID", ssmInstanceID)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.CreateConnectorResponse
  ) extends zio.aws.mgn.model.CreateConnectorResponse.ReadOnly {
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.mgn.model.primitives.ARN(value))
    override val connectorID: Optional[ConnectorID] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorID())
      .map(value => zio.aws.mgn.model.primitives.ConnectorID(value))
    override val name: Optional[ConnectorName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.mgn.model.primitives.ConnectorName(value))
    override val ssmCommandConfig
        : Optional[zio.aws.mgn.model.ConnectorSsmCommandConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ssmCommandConfig())
        .map(value => zio.aws.mgn.model.ConnectorSsmCommandConfig.wrap(value))
    override val ssmInstanceID: Optional[SsmInstanceID] = zio.aws.core.internal
      .optionalFromNullable(impl.ssmInstanceID())
      .map(value => zio.aws.mgn.model.primitives.SsmInstanceID(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.CreateConnectorResponse
  ): zio.aws.mgn.model.CreateConnectorResponse.ReadOnly = new Wrapper(impl)
}
