package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  ISO8601DurationString,
  ISO8601DatetimeString
}
import scala.jdk.CollectionConverters._
final case class DataReplicationInfo(
    dataReplicationError: Optional[zio.aws.mgn.model.DataReplicationError] =
      Optional.Absent,
    dataReplicationInitiation: Optional[
      zio.aws.mgn.model.DataReplicationInitiation
    ] = Optional.Absent,
    dataReplicationState: Optional[zio.aws.mgn.model.DataReplicationState] =
      Optional.Absent,
    etaDateTime: Optional[ISO8601DatetimeString] = Optional.Absent,
    lagDuration: Optional[ISO8601DurationString] = Optional.Absent,
    lastSnapshotDateTime: Optional[ISO8601DatetimeString] = Optional.Absent,
    replicatedDisks: Optional[
      Iterable[zio.aws.mgn.model.DataReplicationInfoReplicatedDisk]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DataReplicationInfo = {
    import DataReplicationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DataReplicationInfo
      .builder()
      .optionallyWith(dataReplicationError.map(value => value.buildAwsValue()))(
        _.dataReplicationError
      )
      .optionallyWith(
        dataReplicationInitiation.map(value => value.buildAwsValue())
      )(_.dataReplicationInitiation)
      .optionallyWith(dataReplicationState.map(value => value.unwrap))(
        _.dataReplicationState
      )
      .optionallyWith(
        etaDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.etaDateTime)
      .optionallyWith(
        lagDuration.map(value =>
          ISO8601DurationString.unwrap(value): java.lang.String
        )
      )(_.lagDuration)
      .optionallyWith(
        lastSnapshotDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.lastSnapshotDateTime)
      .optionallyWith(
        replicatedDisks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicatedDisks)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DataReplicationInfo.ReadOnly =
    zio.aws.mgn.model.DataReplicationInfo.wrap(buildAwsValue())
}
object DataReplicationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DataReplicationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DataReplicationInfo =
      zio.aws.mgn.model.DataReplicationInfo(
        dataReplicationError.map(value => value.asEditable),
        dataReplicationInitiation.map(value => value.asEditable),
        dataReplicationState.map(value => value),
        etaDateTime.map(value => value),
        lagDuration.map(value => value),
        lastSnapshotDateTime.map(value => value),
        replicatedDisks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dataReplicationError
        : Optional[zio.aws.mgn.model.DataReplicationError.ReadOnly]
    def dataReplicationInitiation
        : Optional[zio.aws.mgn.model.DataReplicationInitiation.ReadOnly]
    def dataReplicationState: Optional[zio.aws.mgn.model.DataReplicationState]
    def etaDateTime: Optional[ISO8601DatetimeString]
    def lagDuration: Optional[ISO8601DurationString]
    def lastSnapshotDateTime: Optional[ISO8601DatetimeString]
    def replicatedDisks: Optional[
      List[zio.aws.mgn.model.DataReplicationInfoReplicatedDisk.ReadOnly]
    ]
    def getDataReplicationError
        : ZIO[Any, AwsError, zio.aws.mgn.model.DataReplicationError.ReadOnly] =
      AwsError.unwrapOptionField("dataReplicationError", dataReplicationError)
    def getDataReplicationInitiation: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.DataReplicationInitiation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataReplicationInitiation",
      dataReplicationInitiation
    )
    def getDataReplicationState
        : ZIO[Any, AwsError, zio.aws.mgn.model.DataReplicationState] =
      AwsError.unwrapOptionField("dataReplicationState", dataReplicationState)
    def getEtaDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("etaDateTime", etaDateTime)
    def getLagDuration: ZIO[Any, AwsError, ISO8601DurationString] =
      AwsError.unwrapOptionField("lagDuration", lagDuration)
    def getLastSnapshotDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("lastSnapshotDateTime", lastSnapshotDateTime)
    def getReplicatedDisks: ZIO[Any, AwsError, List[
      zio.aws.mgn.model.DataReplicationInfoReplicatedDisk.ReadOnly
    ]] = AwsError.unwrapOptionField("replicatedDisks", replicatedDisks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DataReplicationInfo
  ) extends zio.aws.mgn.model.DataReplicationInfo.ReadOnly {
    override val dataReplicationError
        : Optional[zio.aws.mgn.model.DataReplicationError.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataReplicationError())
        .map(value => zio.aws.mgn.model.DataReplicationError.wrap(value))
    override val dataReplicationInitiation
        : Optional[zio.aws.mgn.model.DataReplicationInitiation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataReplicationInitiation())
        .map(value => zio.aws.mgn.model.DataReplicationInitiation.wrap(value))
    override val dataReplicationState
        : Optional[zio.aws.mgn.model.DataReplicationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataReplicationState())
        .map(value => zio.aws.mgn.model.DataReplicationState.wrap(value))
    override val etaDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.etaDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val lagDuration: Optional[ISO8601DurationString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lagDuration())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DurationString(value))
    override val lastSnapshotDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSnapshotDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val replicatedDisks: Optional[
      List[zio.aws.mgn.model.DataReplicationInfoReplicatedDisk.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicatedDisks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.DataReplicationInfoReplicatedDisk.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DataReplicationInfo
  ): zio.aws.mgn.model.DataReplicationInfo.ReadOnly = new Wrapper(impl)
}
