package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{JobID, AccountID}
import scala.jdk.CollectionConverters._
final case class DeleteJobRequest(
    accountID: Optional[AccountID] = Optional.Absent,
    jobID: JobID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DeleteJobRequest = {
    import DeleteJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DeleteJobRequest
      .builder()
      .optionallyWith(
        accountID.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.accountID)
      .jobID(JobID.unwrap(jobID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DeleteJobRequest.ReadOnly =
    zio.aws.mgn.model.DeleteJobRequest.wrap(buildAwsValue())
}
object DeleteJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DeleteJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DeleteJobRequest =
      zio.aws.mgn.model.DeleteJobRequest(accountID.map(value => value), jobID)
    def accountID: Optional[AccountID]
    def jobID: JobID
    def getAccountID: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("accountID", accountID)
    def getJobID: ZIO[Any, Nothing, JobID] = ZIO.succeed(jobID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DeleteJobRequest
  ) extends zio.aws.mgn.model.DeleteJobRequest.ReadOnly {
    override val accountID: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.accountID())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val jobID: JobID = zio.aws.mgn.model.primitives.JobID(impl.jobID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DeleteJobRequest
  ): zio.aws.mgn.model.DeleteJobRequest.ReadOnly = new Wrapper(impl)
}
