package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.VcenterClientID
import scala.jdk.CollectionConverters._
final case class DeleteVcenterClientRequest(vcenterClientID: VcenterClientID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DeleteVcenterClientRequest = {
    import DeleteVcenterClientRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DeleteVcenterClientRequest
      .builder()
      .vcenterClientID(
        VcenterClientID.unwrap(vcenterClientID): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DeleteVcenterClientRequest.ReadOnly =
    zio.aws.mgn.model.DeleteVcenterClientRequest.wrap(buildAwsValue())
}
object DeleteVcenterClientRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DeleteVcenterClientRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DeleteVcenterClientRequest =
      zio.aws.mgn.model.DeleteVcenterClientRequest(vcenterClientID)
    def vcenterClientID: VcenterClientID
    def getVcenterClientID: ZIO[Any, Nothing, VcenterClientID] =
      ZIO.succeed(vcenterClientID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DeleteVcenterClientRequest
  ) extends zio.aws.mgn.model.DeleteVcenterClientRequest.ReadOnly {
    override val vcenterClientID: VcenterClientID =
      zio.aws.mgn.model.primitives.VcenterClientID(impl.vcenterClientID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DeleteVcenterClientRequest
  ): zio.aws.mgn.model.DeleteVcenterClientRequest.ReadOnly = new Wrapper(impl)
}
