package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{WaveID, AccountID}
import scala.jdk.CollectionConverters._
final case class DeleteWaveRequest(
    accountID: Optional[AccountID] = Optional.Absent,
    waveID: WaveID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DeleteWaveRequest = {
    import DeleteWaveRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DeleteWaveRequest
      .builder()
      .optionallyWith(
        accountID.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.accountID)
      .waveID(WaveID.unwrap(waveID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DeleteWaveRequest.ReadOnly =
    zio.aws.mgn.model.DeleteWaveRequest.wrap(buildAwsValue())
}
object DeleteWaveRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DeleteWaveRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DeleteWaveRequest =
      zio.aws.mgn.model.DeleteWaveRequest(accountID.map(value => value), waveID)
    def accountID: Optional[AccountID]
    def waveID: WaveID
    def getAccountID: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("accountID", accountID)
    def getWaveID: ZIO[Any, Nothing, WaveID] = ZIO.succeed(waveID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DeleteWaveRequest
  ) extends zio.aws.mgn.model.DeleteWaveRequest.ReadOnly {
    override val accountID: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.accountID())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val waveID: WaveID =
      zio.aws.mgn.model.primitives.WaveID(impl.waveID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DeleteWaveRequest
  ): zio.aws.mgn.model.DeleteWaveRequest.ReadOnly = new Wrapper(impl)
}
