package zio.aws.mgn.model
import zio.aws.mgn.model.primitives.{
  ReplicationConfigurationTemplateID,
  PaginationToken,
  MaxResultsType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeReplicationConfigurationTemplatesRequest(
    maxResults: Optional[MaxResultsType] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    replicationConfigurationTemplateIDs: Optional[
      Iterable[ReplicationConfigurationTemplateID]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest = {
    import DescribeReplicationConfigurationTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResultsType.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        replicationConfigurationTemplateIDs.map(value =>
          value.map { item =>
            ReplicationConfigurationTemplateID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.replicationConfigurationTemplateIDs)
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesRequest.ReadOnly =
    zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesRequest
      .wrap(buildAwsValue())
}
object DescribeReplicationConfigurationTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesRequest =
      zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        replicationConfigurationTemplateIDs.map(value => value)
      )
    def maxResults: Optional[MaxResultsType]
    def nextToken: Optional[PaginationToken]
    def replicationConfigurationTemplateIDs
        : Optional[List[ReplicationConfigurationTemplateID]]
    def getMaxResults: ZIO[Any, AwsError, MaxResultsType] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReplicationConfigurationTemplateIDs
        : ZIO[Any, AwsError, List[ReplicationConfigurationTemplateID]] =
      AwsError.unwrapOptionField(
        "replicationConfigurationTemplateIDs",
        replicationConfigurationTemplateIDs
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest
  ) extends zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesRequest.ReadOnly {
    override val maxResults: Optional[MaxResultsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.mgn.model.primitives.MaxResultsType(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
    override val replicationConfigurationTemplateIDs
        : Optional[List[ReplicationConfigurationTemplateID]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationConfigurationTemplateIDs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mgn.model.primitives
              .ReplicationConfigurationTemplateID(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest
  ): zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesRequest.ReadOnly =
    new Wrapper(impl)
}
