package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.LargeBoundedString
import scala.jdk.CollectionConverters._
final case class ExportErrorData(
    rawError: Optional[LargeBoundedString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ExportErrorData = {
    import ExportErrorData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ExportErrorData
      .builder()
      .optionallyWith(
        rawError.map(value =>
          LargeBoundedString.unwrap(value): java.lang.String
        )
      )(_.rawError)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ExportErrorData.ReadOnly =
    zio.aws.mgn.model.ExportErrorData.wrap(buildAwsValue())
}
object ExportErrorData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ExportErrorData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ExportErrorData =
      zio.aws.mgn.model.ExportErrorData(rawError.map(value => value))
    def rawError: Optional[LargeBoundedString]
    def getRawError: ZIO[Any, AwsError, LargeBoundedString] =
      AwsError.unwrapOptionField("rawError", rawError)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ExportErrorData
  ) extends zio.aws.mgn.model.ExportErrorData.ReadOnly {
    override val rawError: Optional[LargeBoundedString] = zio.aws.core.internal
      .optionalFromNullable(impl.rawError())
      .map(value => zio.aws.mgn.model.primitives.LargeBoundedString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ExportErrorData
  ): zio.aws.mgn.model.ExportErrorData.ReadOnly = new Wrapper(impl)
}
