package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{SourceServerID, AccountID}
import scala.jdk.CollectionConverters._
final case class GetReplicationConfigurationRequest(
    accountID: Optional[AccountID] = Optional.Absent,
    sourceServerID: SourceServerID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationRequest = {
    import GetReplicationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationRequest
      .builder()
      .optionallyWith(
        accountID.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.accountID)
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.GetReplicationConfigurationRequest.ReadOnly =
    zio.aws.mgn.model.GetReplicationConfigurationRequest.wrap(buildAwsValue())
}
object GetReplicationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.GetReplicationConfigurationRequest =
      zio.aws.mgn.model.GetReplicationConfigurationRequest(
        accountID.map(value => value),
        sourceServerID
      )
    def accountID: Optional[AccountID]
    def sourceServerID: SourceServerID
    def getAccountID: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("accountID", accountID)
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationRequest
  ) extends zio.aws.mgn.model.GetReplicationConfigurationRequest.ReadOnly {
    override val accountID: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.accountID())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationRequest
  ): zio.aws.mgn.model.GetReplicationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
