package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{ImportID, ISO8601DatetimeString}
import scala.jdk.CollectionConverters._
final case class ImportTask(
    creationDateTime: Optional[ISO8601DatetimeString] = Optional.Absent,
    endDateTime: Optional[ISO8601DatetimeString] = Optional.Absent,
    importID: Optional[ImportID] = Optional.Absent,
    progressPercentage: Optional[Float] = Optional.Absent,
    s3BucketSource: Optional[zio.aws.mgn.model.S3BucketSource] =
      Optional.Absent,
    status: Optional[zio.aws.mgn.model.ImportStatus] = Optional.Absent,
    summary: Optional[zio.aws.mgn.model.ImportTaskSummary] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.mgn.model.ImportTask = {
    import ImportTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ImportTask
      .builder()
      .optionallyWith(
        creationDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.creationDateTime)
      .optionallyWith(
        endDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.endDateTime)
      .optionallyWith(
        importID.map(value => ImportID.unwrap(value): java.lang.String)
      )(_.importID)
      .optionallyWith(progressPercentage.map(value => value: java.lang.Float))(
        _.progressPercentage
      )
      .optionallyWith(s3BucketSource.map(value => value.buildAwsValue()))(
        _.s3BucketSource
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ImportTask.ReadOnly =
    zio.aws.mgn.model.ImportTask.wrap(buildAwsValue())
}
object ImportTask {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mgn.model.ImportTask] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ImportTask = zio.aws.mgn.model.ImportTask(
      creationDateTime.map(value => value),
      endDateTime.map(value => value),
      importID.map(value => value),
      progressPercentage.map(value => value),
      s3BucketSource.map(value => value.asEditable),
      status.map(value => value),
      summary.map(value => value.asEditable)
    )
    def creationDateTime: Optional[ISO8601DatetimeString]
    def endDateTime: Optional[ISO8601DatetimeString]
    def importID: Optional[ImportID]
    def progressPercentage: Optional[Float]
    def s3BucketSource: Optional[zio.aws.mgn.model.S3BucketSource.ReadOnly]
    def status: Optional[zio.aws.mgn.model.ImportStatus]
    def summary: Optional[zio.aws.mgn.model.ImportTaskSummary.ReadOnly]
    def getCreationDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getEndDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("endDateTime", endDateTime)
    def getImportID: ZIO[Any, AwsError, ImportID] =
      AwsError.unwrapOptionField("importID", importID)
    def getProgressPercentage: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("progressPercentage", progressPercentage)
    def getS3BucketSource
        : ZIO[Any, AwsError, zio.aws.mgn.model.S3BucketSource.ReadOnly] =
      AwsError.unwrapOptionField("s3BucketSource", s3BucketSource)
    def getStatus: ZIO[Any, AwsError, zio.aws.mgn.model.ImportStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSummary
        : ZIO[Any, AwsError, zio.aws.mgn.model.ImportTaskSummary.ReadOnly] =
      AwsError.unwrapOptionField("summary", summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ImportTask
  ) extends zio.aws.mgn.model.ImportTask.ReadOnly {
    override val creationDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val endDateTime: Optional[ISO8601DatetimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val importID: Optional[ImportID] = zio.aws.core.internal
      .optionalFromNullable(impl.importID())
      .map(value => zio.aws.mgn.model.primitives.ImportID(value))
    override val progressPercentage: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.progressPercentage())
      .map(value => value: Float)
    override val s3BucketSource
        : Optional[zio.aws.mgn.model.S3BucketSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BucketSource())
        .map(value => zio.aws.mgn.model.S3BucketSource.wrap(value))
    override val status: Optional[zio.aws.mgn.model.ImportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.mgn.model.ImportStatus.wrap(value))
    override val summary
        : Optional[zio.aws.mgn.model.ImportTaskSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.summary())
        .map(value => zio.aws.mgn.model.ImportTaskSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ImportTask
  ): zio.aws.mgn.model.ImportTask.ReadOnly = new Wrapper(impl)
}
