package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait JobType {
  def unwrap: software.amazon.awssdk.services.mgn.model.JobType
}
object JobType {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.JobType
  ): zio.aws.mgn.model.JobType = value match {
    case software.amazon.awssdk.services.mgn.model.JobType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.JobType.LAUNCH =>
      val r = LAUNCH
      r
    case software.amazon.awssdk.services.mgn.model.JobType.TERMINATE =>
      val r = TERMINATE
      r
  }
  case object unknownToSdkVersion extends zio.aws.mgn.model.JobType {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobType =
      software.amazon.awssdk.services.mgn.model.JobType.UNKNOWN_TO_SDK_VERSION
  }
  case object LAUNCH extends zio.aws.mgn.model.JobType {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobType =
      software.amazon.awssdk.services.mgn.model.JobType.LAUNCH
  }
  case object TERMINATE extends zio.aws.mgn.model.JobType {
    override def unwrap: software.amazon.awssdk.services.mgn.model.JobType =
      software.amazon.awssdk.services.mgn.model.JobType.TERMINATE
  }
}
