package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.ImportID
import scala.jdk.CollectionConverters._
final case class ListImportsRequestFilters(
    importIDs: Optional[Iterable[ImportID]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ListImportsRequestFilters = {
    import ListImportsRequestFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ListImportsRequestFilters
      .builder()
      .optionallyWith(
        importIDs.map(value =>
          value.map { item =>
            ImportID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.importIDs)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ListImportsRequestFilters.ReadOnly =
    zio.aws.mgn.model.ListImportsRequestFilters.wrap(buildAwsValue())
}
object ListImportsRequestFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ListImportsRequestFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ListImportsRequestFilters =
      zio.aws.mgn.model.ListImportsRequestFilters(importIDs.map(value => value))
    def importIDs: Optional[List[ImportID]]
    def getImportIDs: ZIO[Any, AwsError, List[ImportID]] =
      AwsError.unwrapOptionField("importIDs", importIDs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ListImportsRequestFilters
  ) extends zio.aws.mgn.model.ListImportsRequestFilters.ReadOnly {
    override val importIDs: Optional[List[ImportID]] = zio.aws.core.internal
      .optionalFromNullable(impl.importIDs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.primitives.ImportID(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ListImportsRequestFilters
  ): zio.aws.mgn.model.ListImportsRequestFilters.ReadOnly = new Wrapper(impl)
}
