package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListManagedAccountsResponse(
    items: Iterable[zio.aws.mgn.model.ManagedAccount],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ListManagedAccountsResponse = {
    import ListManagedAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ListManagedAccountsResponse
      .builder()
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ListManagedAccountsResponse.ReadOnly =
    zio.aws.mgn.model.ListManagedAccountsResponse.wrap(buildAwsValue())
}
object ListManagedAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ListManagedAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ListManagedAccountsResponse =
      zio.aws.mgn.model.ListManagedAccountsResponse(
        items.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def items: List[zio.aws.mgn.model.ManagedAccount.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getItems
        : ZIO[Any, Nothing, List[zio.aws.mgn.model.ManagedAccount.ReadOnly]] =
      ZIO.succeed(items)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ListManagedAccountsResponse
  ) extends zio.aws.mgn.model.ListManagedAccountsResponse.ReadOnly {
    override val items: List[zio.aws.mgn.model.ManagedAccount.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.mgn.model.ManagedAccount.wrap(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ListManagedAccountsResponse
  ): zio.aws.mgn.model.ListManagedAccountsResponse.ReadOnly = new Wrapper(impl)
}
