package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.AccountID
import scala.jdk.CollectionConverters._
final case class ManagedAccount(
    accountId: Optional[AccountID] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ManagedAccount = {
    import ManagedAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ManagedAccount
      .builder()
      .optionallyWith(
        accountId.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ManagedAccount.ReadOnly =
    zio.aws.mgn.model.ManagedAccount.wrap(buildAwsValue())
}
object ManagedAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ManagedAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ManagedAccount =
      zio.aws.mgn.model.ManagedAccount(accountId.map(value => value))
    def accountId: Optional[AccountID]
    def getAccountId: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ManagedAccount
  ) extends zio.aws.mgn.model.ManagedAccount.ReadOnly {
    override val accountId: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ManagedAccount
  ): zio.aws.mgn.model.ManagedAccount.ReadOnly = new Wrapper(impl)
}
