package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{SourceServerID, ActionID, AccountID}
import scala.jdk.CollectionConverters._
final case class RemoveSourceServerActionRequest(
    accountID: Optional[AccountID] = Optional.Absent,
    actionID: ActionID,
    sourceServerID: SourceServerID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.RemoveSourceServerActionRequest = {
    import RemoveSourceServerActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.RemoveSourceServerActionRequest
      .builder()
      .optionallyWith(
        accountID.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.accountID)
      .actionID(ActionID.unwrap(actionID): java.lang.String)
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.RemoveSourceServerActionRequest.ReadOnly =
    zio.aws.mgn.model.RemoveSourceServerActionRequest.wrap(buildAwsValue())
}
object RemoveSourceServerActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.RemoveSourceServerActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.RemoveSourceServerActionRequest =
      zio.aws.mgn.model.RemoveSourceServerActionRequest(
        accountID.map(value => value),
        actionID,
        sourceServerID
      )
    def accountID: Optional[AccountID]
    def actionID: ActionID
    def sourceServerID: SourceServerID
    def getAccountID: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("accountID", accountID)
    def getActionID: ZIO[Any, Nothing, ActionID] = ZIO.succeed(actionID)
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.RemoveSourceServerActionRequest
  ) extends zio.aws.mgn.model.RemoveSourceServerActionRequest.ReadOnly {
    override val accountID: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.accountID())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val actionID: ActionID =
      zio.aws.mgn.model.primitives.ActionID(impl.actionID())
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.RemoveSourceServerActionRequest
  ): zio.aws.mgn.model.RemoveSourceServerActionRequest.ReadOnly = new Wrapper(
    impl
  )
}
