package zio.aws.mgn.model
import zio.aws.mgn.model.primitives.{
  StrictlyPositiveInteger,
  BoundedString,
  ActionName,
  DocumentVersion,
  SsmDocumentParameterName,
  ActionID,
  ActionDescription,
  OrderType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SourceServerActionDocument(
    actionID: Optional[ActionID] = Optional.Absent,
    actionName: Optional[ActionName] = Optional.Absent,
    active: Optional[Boolean] = Optional.Absent,
    category: Optional[zio.aws.mgn.model.ActionCategory] = Optional.Absent,
    description: Optional[ActionDescription] = Optional.Absent,
    documentIdentifier: Optional[BoundedString] = Optional.Absent,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    externalParameters: Optional[
      Map[SsmDocumentParameterName, zio.aws.mgn.model.SsmExternalParameter]
    ] = Optional.Absent,
    mustSucceedForCutover: Optional[Boolean] = Optional.Absent,
    order: Optional[OrderType] = Optional.Absent,
    parameters: Optional[Map[SsmDocumentParameterName, Iterable[
      zio.aws.mgn.model.SsmParameterStoreParameter
    ]]] = Optional.Absent,
    timeoutSeconds: Optional[StrictlyPositiveInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.SourceServerActionDocument = {
    import SourceServerActionDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.SourceServerActionDocument
      .builder()
      .optionallyWith(
        actionID.map(value => ActionID.unwrap(value): java.lang.String)
      )(_.actionID)
      .optionallyWith(
        actionName.map(value => ActionName.unwrap(value): java.lang.String)
      )(_.actionName)
      .optionallyWith(active.map(value => value: java.lang.Boolean))(_.active)
      .optionallyWith(category.map(value => value.unwrap))(_.category)
      .optionallyWith(
        description.map(value =>
          ActionDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        documentIdentifier.map(value =>
          BoundedString.unwrap(value): java.lang.String
        )
      )(_.documentIdentifier)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        externalParameters.map(value =>
          value
            .map({ case (key, value) =>
              (SsmDocumentParameterName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.externalParameters)
      .optionallyWith(
        mustSucceedForCutover.map(value => value: java.lang.Boolean)
      )(_.mustSucceedForCutover)
      .optionallyWith(order.map(value => OrderType.unwrap(value): Integer))(
        _.order
      )
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (SsmDocumentParameterName
                .unwrap(key): java.lang.String) -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        timeoutSeconds.map(value =>
          StrictlyPositiveInteger.unwrap(value): Integer
        )
      )(_.timeoutSeconds)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.SourceServerActionDocument.ReadOnly =
    zio.aws.mgn.model.SourceServerActionDocument.wrap(buildAwsValue())
}
object SourceServerActionDocument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.SourceServerActionDocument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.SourceServerActionDocument =
      zio.aws.mgn.model.SourceServerActionDocument(
        actionID.map(value => value),
        actionName.map(value => value),
        active.map(value => value),
        category.map(value => value),
        description.map(value => value),
        documentIdentifier.map(value => value),
        documentVersion.map(value => value),
        externalParameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        mustSucceedForCutover.map(value => value),
        order.map(value => value),
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        timeoutSeconds.map(value => value)
      )
    def actionID: Optional[ActionID]
    def actionName: Optional[ActionName]
    def active: Optional[Boolean]
    def category: Optional[zio.aws.mgn.model.ActionCategory]
    def description: Optional[ActionDescription]
    def documentIdentifier: Optional[BoundedString]
    def documentVersion: Optional[DocumentVersion]
    def externalParameters: Optional[Map[
      SsmDocumentParameterName,
      zio.aws.mgn.model.SsmExternalParameter.ReadOnly
    ]]
    def mustSucceedForCutover: Optional[Boolean]
    def order: Optional[OrderType]
    def parameters: Optional[Map[SsmDocumentParameterName, List[
      zio.aws.mgn.model.SsmParameterStoreParameter.ReadOnly
    ]]]
    def timeoutSeconds: Optional[StrictlyPositiveInteger]
    def getActionID: ZIO[Any, AwsError, ActionID] =
      AwsError.unwrapOptionField("actionID", actionID)
    def getActionName: ZIO[Any, AwsError, ActionName] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("active", active)
    def getCategory: ZIO[Any, AwsError, zio.aws.mgn.model.ActionCategory] =
      AwsError.unwrapOptionField("category", category)
    def getDescription: ZIO[Any, AwsError, ActionDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDocumentIdentifier: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("documentIdentifier", documentIdentifier)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getExternalParameters: ZIO[Any, AwsError, Map[
      SsmDocumentParameterName,
      zio.aws.mgn.model.SsmExternalParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("externalParameters", externalParameters)
    def getMustSucceedForCutover: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("mustSucceedForCutover", mustSucceedForCutover)
    def getOrder: ZIO[Any, AwsError, OrderType] =
      AwsError.unwrapOptionField("order", order)
    def getParameters: ZIO[Any, AwsError, Map[SsmDocumentParameterName, List[
      zio.aws.mgn.model.SsmParameterStoreParameter.ReadOnly
    ]]] = AwsError.unwrapOptionField("parameters", parameters)
    def getTimeoutSeconds: ZIO[Any, AwsError, StrictlyPositiveInteger] =
      AwsError.unwrapOptionField("timeoutSeconds", timeoutSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.SourceServerActionDocument
  ) extends zio.aws.mgn.model.SourceServerActionDocument.ReadOnly {
    override val actionID: Optional[ActionID] = zio.aws.core.internal
      .optionalFromNullable(impl.actionID())
      .map(value => zio.aws.mgn.model.primitives.ActionID(value))
    override val actionName: Optional[ActionName] = zio.aws.core.internal
      .optionalFromNullable(impl.actionName())
      .map(value => zio.aws.mgn.model.primitives.ActionName(value))
    override val active: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.active())
      .map(value => value: Boolean)
    override val category: Optional[zio.aws.mgn.model.ActionCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.category())
        .map(value => zio.aws.mgn.model.ActionCategory.wrap(value))
    override val description: Optional[ActionDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.mgn.model.primitives.ActionDescription(value))
    override val documentIdentifier: Optional[BoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentIdentifier())
        .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.mgn.model.primitives.DocumentVersion(value))
    override val externalParameters: Optional[Map[
      SsmDocumentParameterName,
      zio.aws.mgn.model.SsmExternalParameter.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.externalParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives.SsmDocumentParameterName(
              key
            ) -> zio.aws.mgn.model.SsmExternalParameter.wrap(value)
          })
          .toMap
      )
    override val mustSucceedForCutover: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mustSucceedForCutover())
        .map(value => value: Boolean)
    override val order: Optional[OrderType] = zio.aws.core.internal
      .optionalFromNullable(impl.order())
      .map(value => zio.aws.mgn.model.primitives.OrderType(value))
    override val parameters: Optional[Map[SsmDocumentParameterName, List[
      zio.aws.mgn.model.SsmParameterStoreParameter.ReadOnly
    ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .SsmDocumentParameterName(key) -> value.asScala.map { item =>
              zio.aws.mgn.model.SsmParameterStoreParameter.wrap(item)
            }.toList
          })
          .toMap
      )
    override val timeoutSeconds: Optional[StrictlyPositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutSeconds())
        .map(value =>
          zio.aws.mgn.model.primitives.StrictlyPositiveInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.SourceServerActionDocument
  ): zio.aws.mgn.model.SourceServerActionDocument.ReadOnly = new Wrapper(impl)
}
