package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait SsmDocumentType {
  def unwrap: software.amazon.awssdk.services.mgn.model.SsmDocumentType
}
object SsmDocumentType {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.SsmDocumentType
  ): zio.aws.mgn.model.SsmDocumentType = value match {
    case software.amazon.awssdk.services.mgn.model.SsmDocumentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.SsmDocumentType.AUTOMATION =>
      val r = AUTOMATION
      r
    case software.amazon.awssdk.services.mgn.model.SsmDocumentType.COMMAND =>
      val r = COMMAND
      r
  }
  case object unknownToSdkVersion extends zio.aws.mgn.model.SsmDocumentType {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.SsmDocumentType =
      software.amazon.awssdk.services.mgn.model.SsmDocumentType.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTOMATION extends zio.aws.mgn.model.SsmDocumentType {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.SsmDocumentType =
      software.amazon.awssdk.services.mgn.model.SsmDocumentType.AUTOMATION
  }
  case object COMMAND extends zio.aws.mgn.model.SsmDocumentType {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.SsmDocumentType =
      software.amazon.awssdk.services.mgn.model.SsmDocumentType.COMMAND
  }
}
