package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartImportResponse(
    importTask: Optional[zio.aws.mgn.model.ImportTask] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.StartImportResponse = {
    import StartImportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.StartImportResponse
      .builder()
      .optionallyWith(importTask.map(value => value.buildAwsValue()))(
        _.importTask
      )
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.StartImportResponse.ReadOnly =
    zio.aws.mgn.model.StartImportResponse.wrap(buildAwsValue())
}
object StartImportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.StartImportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.StartImportResponse = zio.aws.mgn.model
      .StartImportResponse(importTask.map(value => value.asEditable))
    def importTask: Optional[zio.aws.mgn.model.ImportTask.ReadOnly]
    def getImportTask
        : ZIO[Any, AwsError, zio.aws.mgn.model.ImportTask.ReadOnly] =
      AwsError.unwrapOptionField("importTask", importTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.StartImportResponse
  ) extends zio.aws.mgn.model.StartImportResponse.ReadOnly {
    override val importTask: Optional[zio.aws.mgn.model.ImportTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importTask())
        .map(value => zio.aws.mgn.model.ImportTask.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.StartImportResponse
  ): zio.aws.mgn.model.StartImportResponse.ReadOnly = new Wrapper(impl)
}
