package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{SourceServerID, AccountID}
import scala.jdk.CollectionConverters._
final case class StopReplicationRequest(
    accountID: Optional[AccountID] = Optional.Absent,
    sourceServerID: SourceServerID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.StopReplicationRequest = {
    import StopReplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.StopReplicationRequest
      .builder()
      .optionallyWith(
        accountID.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.accountID)
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.StopReplicationRequest.ReadOnly =
    zio.aws.mgn.model.StopReplicationRequest.wrap(buildAwsValue())
}
object StopReplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.StopReplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.StopReplicationRequest = zio.aws.mgn.model
      .StopReplicationRequest(accountID.map(value => value), sourceServerID)
    def accountID: Optional[AccountID]
    def sourceServerID: SourceServerID
    def getAccountID: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("accountID", accountID)
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.StopReplicationRequest
  ) extends zio.aws.mgn.model.StopReplicationRequest.ReadOnly {
    override val accountID: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.accountID())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.StopReplicationRequest
  ): zio.aws.mgn.model.StopReplicationRequest.ReadOnly = new Wrapper(impl)
}
