package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{WaveID, AccountID}
import scala.jdk.CollectionConverters._
final case class UnarchiveWaveRequest(
    accountID: Optional[AccountID] = Optional.Absent,
    waveID: WaveID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.UnarchiveWaveRequest = {
    import UnarchiveWaveRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.UnarchiveWaveRequest
      .builder()
      .optionallyWith(
        accountID.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.accountID)
      .waveID(WaveID.unwrap(waveID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.UnarchiveWaveRequest.ReadOnly =
    zio.aws.mgn.model.UnarchiveWaveRequest.wrap(buildAwsValue())
}
object UnarchiveWaveRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.UnarchiveWaveRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.UnarchiveWaveRequest = zio.aws.mgn.model
      .UnarchiveWaveRequest(accountID.map(value => value), waveID)
    def accountID: Optional[AccountID]
    def waveID: WaveID
    def getAccountID: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("accountID", accountID)
    def getWaveID: ZIO[Any, Nothing, WaveID] = ZIO.succeed(waveID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.UnarchiveWaveRequest
  ) extends zio.aws.mgn.model.UnarchiveWaveRequest.ReadOnly {
    override val accountID: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.accountID())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val waveID: WaveID =
      zio.aws.mgn.model.primitives.WaveID(impl.waveID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.UnarchiveWaveRequest
  ): zio.aws.mgn.model.UnarchiveWaveRequest.ReadOnly = new Wrapper(impl)
}
