package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  SourceServerID,
  SmallBoundedString,
  TagValue,
  AccountID
}
import scala.jdk.CollectionConverters._
final case class UpdateLaunchConfigurationRequest(
    accountID: Optional[AccountID] = Optional.Absent,
    bootMode: Optional[zio.aws.mgn.model.BootMode] = Optional.Absent,
    copyPrivateIp: Optional[Boolean] = Optional.Absent,
    copyTags: Optional[Boolean] = Optional.Absent,
    enableMapAutoTagging: Optional[Boolean] = Optional.Absent,
    launchDisposition: Optional[zio.aws.mgn.model.LaunchDisposition] =
      Optional.Absent,
    licensing: Optional[zio.aws.mgn.model.Licensing] = Optional.Absent,
    mapAutoTaggingMpeID: Optional[TagValue] = Optional.Absent,
    name: Optional[SmallBoundedString] = Optional.Absent,
    postLaunchActions: Optional[zio.aws.mgn.model.PostLaunchActions] =
      Optional.Absent,
    sourceServerID: SourceServerID,
    targetInstanceTypeRightSizingMethod: Optional[
      zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationRequest = {
    import UpdateLaunchConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationRequest
      .builder()
      .optionallyWith(
        accountID.map(value => AccountID.unwrap(value): java.lang.String)
      )(_.accountID)
      .optionallyWith(bootMode.map(value => value.unwrap))(_.bootMode)
      .optionallyWith(copyPrivateIp.map(value => value: java.lang.Boolean))(
        _.copyPrivateIp
      )
      .optionallyWith(copyTags.map(value => value: java.lang.Boolean))(
        _.copyTags
      )
      .optionallyWith(
        enableMapAutoTagging.map(value => value: java.lang.Boolean)
      )(_.enableMapAutoTagging)
      .optionallyWith(launchDisposition.map(value => value.unwrap))(
        _.launchDisposition
      )
      .optionallyWith(licensing.map(value => value.buildAwsValue()))(
        _.licensing
      )
      .optionallyWith(
        mapAutoTaggingMpeID.map(value =>
          TagValue.unwrap(value): java.lang.String
        )
      )(_.mapAutoTaggingMpeID)
      .optionallyWith(
        name.map(value => SmallBoundedString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(postLaunchActions.map(value => value.buildAwsValue()))(
        _.postLaunchActions
      )
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .optionallyWith(
        targetInstanceTypeRightSizingMethod.map(value => value.unwrap)
      )(_.targetInstanceTypeRightSizingMethod)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.UpdateLaunchConfigurationRequest.ReadOnly =
    zio.aws.mgn.model.UpdateLaunchConfigurationRequest.wrap(buildAwsValue())
}
object UpdateLaunchConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.UpdateLaunchConfigurationRequest =
      zio.aws.mgn.model.UpdateLaunchConfigurationRequest(
        accountID.map(value => value),
        bootMode.map(value => value),
        copyPrivateIp.map(value => value),
        copyTags.map(value => value),
        enableMapAutoTagging.map(value => value),
        launchDisposition.map(value => value),
        licensing.map(value => value.asEditable),
        mapAutoTaggingMpeID.map(value => value),
        name.map(value => value),
        postLaunchActions.map(value => value.asEditable),
        sourceServerID,
        targetInstanceTypeRightSizingMethod.map(value => value)
      )
    def accountID: Optional[AccountID]
    def bootMode: Optional[zio.aws.mgn.model.BootMode]
    def copyPrivateIp: Optional[Boolean]
    def copyTags: Optional[Boolean]
    def enableMapAutoTagging: Optional[Boolean]
    def launchDisposition: Optional[zio.aws.mgn.model.LaunchDisposition]
    def licensing: Optional[zio.aws.mgn.model.Licensing.ReadOnly]
    def mapAutoTaggingMpeID: Optional[TagValue]
    def name: Optional[SmallBoundedString]
    def postLaunchActions
        : Optional[zio.aws.mgn.model.PostLaunchActions.ReadOnly]
    def sourceServerID: SourceServerID
    def targetInstanceTypeRightSizingMethod
        : Optional[zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod]
    def getAccountID: ZIO[Any, AwsError, AccountID] =
      AwsError.unwrapOptionField("accountID", accountID)
    def getBootMode: ZIO[Any, AwsError, zio.aws.mgn.model.BootMode] =
      AwsError.unwrapOptionField("bootMode", bootMode)
    def getCopyPrivateIp: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("copyPrivateIp", copyPrivateIp)
    def getCopyTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("copyTags", copyTags)
    def getEnableMapAutoTagging: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableMapAutoTagging", enableMapAutoTagging)
    def getLaunchDisposition
        : ZIO[Any, AwsError, zio.aws.mgn.model.LaunchDisposition] =
      AwsError.unwrapOptionField("launchDisposition", launchDisposition)
    def getLicensing: ZIO[Any, AwsError, zio.aws.mgn.model.Licensing.ReadOnly] =
      AwsError.unwrapOptionField("licensing", licensing)
    def getMapAutoTaggingMpeID: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("mapAutoTaggingMpeID", mapAutoTaggingMpeID)
    def getName: ZIO[Any, AwsError, SmallBoundedString] =
      AwsError.unwrapOptionField("name", name)
    def getPostLaunchActions
        : ZIO[Any, AwsError, zio.aws.mgn.model.PostLaunchActions.ReadOnly] =
      AwsError.unwrapOptionField("postLaunchActions", postLaunchActions)
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
    def getTargetInstanceTypeRightSizingMethod: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod
    ] = AwsError.unwrapOptionField(
      "targetInstanceTypeRightSizingMethod",
      targetInstanceTypeRightSizingMethod
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationRequest
  ) extends zio.aws.mgn.model.UpdateLaunchConfigurationRequest.ReadOnly {
    override val accountID: Optional[AccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.accountID())
      .map(value => zio.aws.mgn.model.primitives.AccountID(value))
    override val bootMode: Optional[zio.aws.mgn.model.BootMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bootMode())
        .map(value => zio.aws.mgn.model.BootMode.wrap(value))
    override val copyPrivateIp: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.copyPrivateIp())
      .map(value => value: Boolean)
    override val copyTags: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTags())
      .map(value => value: Boolean)
    override val enableMapAutoTagging: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableMapAutoTagging())
      .map(value => value: Boolean)
    override val launchDisposition
        : Optional[zio.aws.mgn.model.LaunchDisposition] = zio.aws.core.internal
      .optionalFromNullable(impl.launchDisposition())
      .map(value => zio.aws.mgn.model.LaunchDisposition.wrap(value))
    override val licensing: Optional[zio.aws.mgn.model.Licensing.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licensing())
        .map(value => zio.aws.mgn.model.Licensing.wrap(value))
    override val mapAutoTaggingMpeID: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.mapAutoTaggingMpeID())
      .map(value => zio.aws.mgn.model.primitives.TagValue(value))
    override val name: Optional[SmallBoundedString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.mgn.model.primitives.SmallBoundedString(value))
    override val postLaunchActions
        : Optional[zio.aws.mgn.model.PostLaunchActions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postLaunchActions())
        .map(value => zio.aws.mgn.model.PostLaunchActions.wrap(value))
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
    override val targetInstanceTypeRightSizingMethod
        : Optional[zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetInstanceTypeRightSizingMethod())
        .map(value =>
          zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationRequest
  ): zio.aws.mgn.model.UpdateLaunchConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
