package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  SourceServerID,
  SmallBoundedString,
  TagValue,
  BoundedString
}
import scala.jdk.CollectionConverters._
final case class UpdateLaunchConfigurationResponse(
    bootMode: Optional[zio.aws.mgn.model.BootMode] = Optional.Absent,
    copyPrivateIp: Optional[Boolean] = Optional.Absent,
    copyTags: Optional[Boolean] = Optional.Absent,
    ec2LaunchTemplateID: Optional[BoundedString] = Optional.Absent,
    enableMapAutoTagging: Optional[Boolean] = Optional.Absent,
    launchDisposition: Optional[zio.aws.mgn.model.LaunchDisposition] =
      Optional.Absent,
    licensing: Optional[zio.aws.mgn.model.Licensing] = Optional.Absent,
    mapAutoTaggingMpeID: Optional[TagValue] = Optional.Absent,
    name: Optional[SmallBoundedString] = Optional.Absent,
    postLaunchActions: Optional[zio.aws.mgn.model.PostLaunchActions] =
      Optional.Absent,
    sourceServerID: Optional[SourceServerID] = Optional.Absent,
    targetInstanceTypeRightSizingMethod: Optional[
      zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationResponse = {
    import UpdateLaunchConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationResponse
      .builder()
      .optionallyWith(bootMode.map(value => value.unwrap))(_.bootMode)
      .optionallyWith(copyPrivateIp.map(value => value: java.lang.Boolean))(
        _.copyPrivateIp
      )
      .optionallyWith(copyTags.map(value => value: java.lang.Boolean))(
        _.copyTags
      )
      .optionallyWith(
        ec2LaunchTemplateID.map(value =>
          BoundedString.unwrap(value): java.lang.String
        )
      )(_.ec2LaunchTemplateID)
      .optionallyWith(
        enableMapAutoTagging.map(value => value: java.lang.Boolean)
      )(_.enableMapAutoTagging)
      .optionallyWith(launchDisposition.map(value => value.unwrap))(
        _.launchDisposition
      )
      .optionallyWith(licensing.map(value => value.buildAwsValue()))(
        _.licensing
      )
      .optionallyWith(
        mapAutoTaggingMpeID.map(value =>
          TagValue.unwrap(value): java.lang.String
        )
      )(_.mapAutoTaggingMpeID)
      .optionallyWith(
        name.map(value => SmallBoundedString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(postLaunchActions.map(value => value.buildAwsValue()))(
        _.postLaunchActions
      )
      .optionallyWith(
        sourceServerID.map(value =>
          SourceServerID.unwrap(value): java.lang.String
        )
      )(_.sourceServerID)
      .optionallyWith(
        targetInstanceTypeRightSizingMethod.map(value => value.unwrap)
      )(_.targetInstanceTypeRightSizingMethod)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.UpdateLaunchConfigurationResponse.ReadOnly =
    zio.aws.mgn.model.UpdateLaunchConfigurationResponse.wrap(buildAwsValue())
}
object UpdateLaunchConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.UpdateLaunchConfigurationResponse =
      zio.aws.mgn.model.UpdateLaunchConfigurationResponse(
        bootMode.map(value => value),
        copyPrivateIp.map(value => value),
        copyTags.map(value => value),
        ec2LaunchTemplateID.map(value => value),
        enableMapAutoTagging.map(value => value),
        launchDisposition.map(value => value),
        licensing.map(value => value.asEditable),
        mapAutoTaggingMpeID.map(value => value),
        name.map(value => value),
        postLaunchActions.map(value => value.asEditable),
        sourceServerID.map(value => value),
        targetInstanceTypeRightSizingMethod.map(value => value)
      )
    def bootMode: Optional[zio.aws.mgn.model.BootMode]
    def copyPrivateIp: Optional[Boolean]
    def copyTags: Optional[Boolean]
    def ec2LaunchTemplateID: Optional[BoundedString]
    def enableMapAutoTagging: Optional[Boolean]
    def launchDisposition: Optional[zio.aws.mgn.model.LaunchDisposition]
    def licensing: Optional[zio.aws.mgn.model.Licensing.ReadOnly]
    def mapAutoTaggingMpeID: Optional[TagValue]
    def name: Optional[SmallBoundedString]
    def postLaunchActions
        : Optional[zio.aws.mgn.model.PostLaunchActions.ReadOnly]
    def sourceServerID: Optional[SourceServerID]
    def targetInstanceTypeRightSizingMethod
        : Optional[zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod]
    def getBootMode: ZIO[Any, AwsError, zio.aws.mgn.model.BootMode] =
      AwsError.unwrapOptionField("bootMode", bootMode)
    def getCopyPrivateIp: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("copyPrivateIp", copyPrivateIp)
    def getCopyTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("copyTags", copyTags)
    def getEc2LaunchTemplateID: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("ec2LaunchTemplateID", ec2LaunchTemplateID)
    def getEnableMapAutoTagging: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableMapAutoTagging", enableMapAutoTagging)
    def getLaunchDisposition
        : ZIO[Any, AwsError, zio.aws.mgn.model.LaunchDisposition] =
      AwsError.unwrapOptionField("launchDisposition", launchDisposition)
    def getLicensing: ZIO[Any, AwsError, zio.aws.mgn.model.Licensing.ReadOnly] =
      AwsError.unwrapOptionField("licensing", licensing)
    def getMapAutoTaggingMpeID: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("mapAutoTaggingMpeID", mapAutoTaggingMpeID)
    def getName: ZIO[Any, AwsError, SmallBoundedString] =
      AwsError.unwrapOptionField("name", name)
    def getPostLaunchActions
        : ZIO[Any, AwsError, zio.aws.mgn.model.PostLaunchActions.ReadOnly] =
      AwsError.unwrapOptionField("postLaunchActions", postLaunchActions)
    def getSourceServerID: ZIO[Any, AwsError, SourceServerID] =
      AwsError.unwrapOptionField("sourceServerID", sourceServerID)
    def getTargetInstanceTypeRightSizingMethod: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod
    ] = AwsError.unwrapOptionField(
      "targetInstanceTypeRightSizingMethod",
      targetInstanceTypeRightSizingMethod
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationResponse
  ) extends zio.aws.mgn.model.UpdateLaunchConfigurationResponse.ReadOnly {
    override val bootMode: Optional[zio.aws.mgn.model.BootMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bootMode())
        .map(value => zio.aws.mgn.model.BootMode.wrap(value))
    override val copyPrivateIp: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.copyPrivateIp())
      .map(value => value: Boolean)
    override val copyTags: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTags())
      .map(value => value: Boolean)
    override val ec2LaunchTemplateID: Optional[BoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2LaunchTemplateID())
        .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val enableMapAutoTagging: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableMapAutoTagging())
      .map(value => value: Boolean)
    override val launchDisposition
        : Optional[zio.aws.mgn.model.LaunchDisposition] = zio.aws.core.internal
      .optionalFromNullable(impl.launchDisposition())
      .map(value => zio.aws.mgn.model.LaunchDisposition.wrap(value))
    override val licensing: Optional[zio.aws.mgn.model.Licensing.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licensing())
        .map(value => zio.aws.mgn.model.Licensing.wrap(value))
    override val mapAutoTaggingMpeID: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.mapAutoTaggingMpeID())
      .map(value => zio.aws.mgn.model.primitives.TagValue(value))
    override val name: Optional[SmallBoundedString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.mgn.model.primitives.SmallBoundedString(value))
    override val postLaunchActions
        : Optional[zio.aws.mgn.model.PostLaunchActions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postLaunchActions())
        .map(value => zio.aws.mgn.model.PostLaunchActions.wrap(value))
    override val sourceServerID: Optional[SourceServerID] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceServerID())
        .map(value => zio.aws.mgn.model.primitives.SourceServerID(value))
    override val targetInstanceTypeRightSizingMethod
        : Optional[zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetInstanceTypeRightSizingMethod())
        .map(value =>
          zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationResponse
  ): zio.aws.mgn.model.UpdateLaunchConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
