package zio.aws.mturk
import zio.aws.mturk.model.RejectAssignmentResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.mturk.{
  MTurkAsyncClientBuilder,
  MTurkAsyncClient
}
import zio.aws.mturk.model.primitives.EntityId
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.mturk.model.{
  CreateHitTypeResponse,
  ListHiTsForQualificationTypeResponse,
  ListAssignmentsForHitRequest,
  CreateAdditionalAssignmentsForHitRequest,
  NotifyWorkersRequest,
  ListReviewableHiTsResponse,
  CreateQualificationTypeRequest,
  SendBonusResponse,
  WorkerBlock,
  AssociateQualificationWithWorkerResponse,
  SendTestEventNotificationRequest,
  UpdateExpirationForHitRequest,
  ListReviewPolicyResultsForHitRequest,
  DeleteWorkerBlockRequest,
  Assignment,
  Qualification,
  RejectQualificationRequestResponse,
  ListQualificationRequestsRequest,
  CreateQualificationTypeResponse,
  GetHitRequest,
  GetQualificationTypeRequest,
  QualificationType,
  ListBonusPaymentsResponse,
  ApproveAssignmentRequest,
  UpdateExpirationForHitResponse,
  GetFileUploadUrlResponse,
  GetQualificationTypeResponse,
  GetHitResponse,
  CreateHitWithHitTypeRequest,
  UpdateQualificationTypeResponse,
  DeleteHitResponse,
  GetAssignmentResponse,
  NotifyWorkersResponse,
  CreateHitTypeRequest,
  AcceptQualificationRequestResponse,
  AcceptQualificationRequestRequest,
  DeleteWorkerBlockResponse,
  UpdateQualificationTypeRequest,
  UpdateHitReviewStatusRequest,
  HIT,
  GetAccountBalanceResponse,
  CreateHitRequest,
  SendBonusRequest,
  GetQualificationScoreRequest,
  CreateWorkerBlockResponse,
  CreateHitResponse,
  ApproveAssignmentResponse,
  UpdateNotificationSettingsResponse,
  BonusPayment,
  GetFileUploadUrlRequest,
  GetAssignmentRequest,
  ListQualificationTypesRequest,
  DisassociateQualificationFromWorkerResponse,
  ListQualificationTypesResponse,
  DeleteHitRequest,
  ListQualificationRequestsResponse,
  QualificationRequest,
  ListWorkersWithQualificationTypeRequest,
  CreateAdditionalAssignmentsForHitResponse,
  ListBonusPaymentsRequest,
  UpdateHitReviewStatusResponse,
  CreateWorkerBlockRequest,
  GetAccountBalanceRequest,
  RejectAssignmentRequest,
  ListWorkerBlocksResponse,
  DeleteQualificationTypeRequest,
  CreateHitWithHitTypeResponse,
  ListHiTsResponse,
  ListWorkersWithQualificationTypeResponse,
  AssociateQualificationWithWorkerRequest,
  RejectAssignmentResponse,
  DisassociateQualificationFromWorkerRequest,
  ListHiTsRequest,
  ListReviewableHiTsRequest,
  GetQualificationScoreResponse,
  ListAssignmentsForHitResponse,
  ListWorkerBlocksRequest,
  ListHiTsForQualificationTypeRequest,
  DeleteQualificationTypeResponse,
  ListReviewPolicyResultsForHitResponse,
  RejectQualificationRequestRequest,
  UpdateNotificationSettingsRequest,
  SendTestEventNotificationResponse,
  UpdateHitTypeOfHitRequest,
  UpdateHitTypeOfHitResponse
}
import scala.jdk.CollectionConverters._
trait MTurk extends AspectSupport[MTurk] {
  val api: MTurkAsyncClient
  def listReviewableHITs(
      request: zio.aws.mturk.model.ListReviewableHiTsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListReviewableHiTsResponse.ReadOnly,
    zio.aws.mturk.model.HIT.ReadOnly
  ]]
  def listReviewableHITsPaginated(
      request: zio.aws.mturk.model.ListReviewableHiTsRequest
  ): IO[AwsError, zio.aws.mturk.model.ListReviewableHiTsResponse.ReadOnly]
  def listQualificationRequests(
      request: zio.aws.mturk.model.ListQualificationRequestsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListQualificationRequestsResponse.ReadOnly,
    zio.aws.mturk.model.QualificationRequest.ReadOnly
  ]]
  def listQualificationRequestsPaginated(
      request: zio.aws.mturk.model.ListQualificationRequestsRequest
  ): IO[
    AwsError,
    zio.aws.mturk.model.ListQualificationRequestsResponse.ReadOnly
  ]
  def updateQualificationType(
      request: zio.aws.mturk.model.UpdateQualificationTypeRequest
  ): IO[AwsError, zio.aws.mturk.model.UpdateQualificationTypeResponse.ReadOnly]
  def sendTestEventNotification(
      request: zio.aws.mturk.model.SendTestEventNotificationRequest
  ): IO[
    AwsError,
    zio.aws.mturk.model.SendTestEventNotificationResponse.ReadOnly
  ]
  def listBonusPayments(
      request: zio.aws.mturk.model.ListBonusPaymentsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListBonusPaymentsResponse.ReadOnly,
    zio.aws.mturk.model.BonusPayment.ReadOnly
  ]]
  def listBonusPaymentsPaginated(
      request: zio.aws.mturk.model.ListBonusPaymentsRequest
  ): IO[AwsError, zio.aws.mturk.model.ListBonusPaymentsResponse.ReadOnly]
  def listQualificationTypes(
      request: zio.aws.mturk.model.ListQualificationTypesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListQualificationTypesResponse.ReadOnly,
    zio.aws.mturk.model.QualificationType.ReadOnly
  ]]
  def listQualificationTypesPaginated(
      request: zio.aws.mturk.model.ListQualificationTypesRequest
  ): IO[AwsError, zio.aws.mturk.model.ListQualificationTypesResponse.ReadOnly]
  def getHIT(
      request: zio.aws.mturk.model.GetHitRequest
  ): IO[AwsError, zio.aws.mturk.model.GetHitResponse.ReadOnly]
  def createQualificationType(
      request: zio.aws.mturk.model.CreateQualificationTypeRequest
  ): IO[AwsError, zio.aws.mturk.model.CreateQualificationTypeResponse.ReadOnly]
  def listReviewPolicyResultsForHIT(
      request: zio.aws.mturk.model.ListReviewPolicyResultsForHitRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse.ReadOnly,
    EntityId
  ]]
  def listReviewPolicyResultsForHITPaginated(
      request: zio.aws.mturk.model.ListReviewPolicyResultsForHitRequest
  ): IO[
    AwsError,
    zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse.ReadOnly
  ]
  def deleteWorkerBlock(
      request: zio.aws.mturk.model.DeleteWorkerBlockRequest
  ): IO[AwsError, zio.aws.mturk.model.DeleteWorkerBlockResponse.ReadOnly]
  def listHITsForQualificationType(
      request: zio.aws.mturk.model.ListHiTsForQualificationTypeRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListHiTsForQualificationTypeResponse.ReadOnly,
    zio.aws.mturk.model.HIT.ReadOnly
  ]]
  def listHITsForQualificationTypePaginated(
      request: zio.aws.mturk.model.ListHiTsForQualificationTypeRequest
  ): IO[
    AwsError,
    zio.aws.mturk.model.ListHiTsForQualificationTypeResponse.ReadOnly
  ]
  def rejectQualificationRequest(
      request: zio.aws.mturk.model.RejectQualificationRequestRequest
  ): IO[
    AwsError,
    zio.aws.mturk.model.RejectQualificationRequestResponse.ReadOnly
  ]
  def acceptQualificationRequest(
      request: zio.aws.mturk.model.AcceptQualificationRequestRequest
  ): IO[
    AwsError,
    zio.aws.mturk.model.AcceptQualificationRequestResponse.ReadOnly
  ]
  def deleteHIT(
      request: zio.aws.mturk.model.DeleteHitRequest
  ): IO[AwsError, zio.aws.mturk.model.DeleteHitResponse.ReadOnly]
  def notifyWorkers(
      request: zio.aws.mturk.model.NotifyWorkersRequest
  ): IO[AwsError, zio.aws.mturk.model.NotifyWorkersResponse.ReadOnly]
  def getQualificationScore(
      request: zio.aws.mturk.model.GetQualificationScoreRequest
  ): IO[AwsError, zio.aws.mturk.model.GetQualificationScoreResponse.ReadOnly]
  def createHITType(
      request: zio.aws.mturk.model.CreateHitTypeRequest
  ): IO[AwsError, zio.aws.mturk.model.CreateHitTypeResponse.ReadOnly]
  def updateNotificationSettings(
      request: zio.aws.mturk.model.UpdateNotificationSettingsRequest
  ): IO[
    AwsError,
    zio.aws.mturk.model.UpdateNotificationSettingsResponse.ReadOnly
  ]
  def listWorkerBlocks(
      request: zio.aws.mturk.model.ListWorkerBlocksRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListWorkerBlocksResponse.ReadOnly,
    zio.aws.mturk.model.WorkerBlock.ReadOnly
  ]]
  def listWorkerBlocksPaginated(
      request: zio.aws.mturk.model.ListWorkerBlocksRequest
  ): IO[AwsError, zio.aws.mturk.model.ListWorkerBlocksResponse.ReadOnly]
  def disassociateQualificationFromWorker(
      request: zio.aws.mturk.model.DisassociateQualificationFromWorkerRequest
  ): IO[
    AwsError,
    zio.aws.mturk.model.DisassociateQualificationFromWorkerResponse.ReadOnly
  ]
  def getQualificationType(
      request: zio.aws.mturk.model.GetQualificationTypeRequest
  ): IO[AwsError, zio.aws.mturk.model.GetQualificationTypeResponse.ReadOnly]
  def listHITs(
      request: zio.aws.mturk.model.ListHiTsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListHiTsResponse.ReadOnly,
    zio.aws.mturk.model.HIT.ReadOnly
  ]]
  def listHITsPaginated(
      request: zio.aws.mturk.model.ListHiTsRequest
  ): IO[AwsError, zio.aws.mturk.model.ListHiTsResponse.ReadOnly]
  def getFileUploadURL(
      request: zio.aws.mturk.model.GetFileUploadUrlRequest
  ): IO[AwsError, zio.aws.mturk.model.GetFileUploadUrlResponse.ReadOnly]
  def listAssignmentsForHIT(
      request: zio.aws.mturk.model.ListAssignmentsForHitRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListAssignmentsForHitResponse.ReadOnly,
    zio.aws.mturk.model.Assignment.ReadOnly
  ]]
  def listAssignmentsForHITPaginated(
      request: zio.aws.mturk.model.ListAssignmentsForHitRequest
  ): IO[AwsError, zio.aws.mturk.model.ListAssignmentsForHitResponse.ReadOnly]
  def getAssignment(
      request: zio.aws.mturk.model.GetAssignmentRequest
  ): IO[AwsError, zio.aws.mturk.model.GetAssignmentResponse.ReadOnly]
  def associateQualificationWithWorker(
      request: zio.aws.mturk.model.AssociateQualificationWithWorkerRequest
  ): IO[
    AwsError,
    zio.aws.mturk.model.AssociateQualificationWithWorkerResponse.ReadOnly
  ]
  def updateHITReviewStatus(
      request: zio.aws.mturk.model.UpdateHitReviewStatusRequest
  ): IO[AwsError, zio.aws.mturk.model.UpdateHitReviewStatusResponse.ReadOnly]
  def createHITWithHITType(
      request: zio.aws.mturk.model.CreateHitWithHitTypeRequest
  ): IO[AwsError, zio.aws.mturk.model.CreateHitWithHitTypeResponse.ReadOnly]
  def updateHITTypeOfHIT(
      request: zio.aws.mturk.model.UpdateHitTypeOfHitRequest
  ): IO[AwsError, zio.aws.mturk.model.UpdateHitTypeOfHitResponse.ReadOnly]
  def createAdditionalAssignmentsForHIT(
      request: zio.aws.mturk.model.CreateAdditionalAssignmentsForHitRequest
  ): IO[
    AwsError,
    zio.aws.mturk.model.CreateAdditionalAssignmentsForHitResponse.ReadOnly
  ]
  def createWorkerBlock(
      request: zio.aws.mturk.model.CreateWorkerBlockRequest
  ): IO[AwsError, zio.aws.mturk.model.CreateWorkerBlockResponse.ReadOnly]
  def approveAssignment(
      request: zio.aws.mturk.model.ApproveAssignmentRequest
  ): IO[AwsError, zio.aws.mturk.model.ApproveAssignmentResponse.ReadOnly]
  def getAccountBalance(
      request: zio.aws.mturk.model.GetAccountBalanceRequest
  ): IO[AwsError, zio.aws.mturk.model.GetAccountBalanceResponse.ReadOnly]
  def listWorkersWithQualificationType(
      request: zio.aws.mturk.model.ListWorkersWithQualificationTypeRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListWorkersWithQualificationTypeResponse.ReadOnly,
    zio.aws.mturk.model.Qualification.ReadOnly
  ]]
  def listWorkersWithQualificationTypePaginated(
      request: zio.aws.mturk.model.ListWorkersWithQualificationTypeRequest
  ): IO[
    AwsError,
    zio.aws.mturk.model.ListWorkersWithQualificationTypeResponse.ReadOnly
  ]
  def createHIT(
      request: zio.aws.mturk.model.CreateHitRequest
  ): IO[AwsError, zio.aws.mturk.model.CreateHitResponse.ReadOnly]
  def sendBonus(
      request: zio.aws.mturk.model.SendBonusRequest
  ): IO[AwsError, zio.aws.mturk.model.SendBonusResponse.ReadOnly]
  def updateExpirationForHIT(
      request: zio.aws.mturk.model.UpdateExpirationForHitRequest
  ): IO[AwsError, zio.aws.mturk.model.UpdateExpirationForHitResponse.ReadOnly]
  def rejectAssignment(
      request: zio.aws.mturk.model.RejectAssignmentRequest
  ): IO[AwsError, ReadOnly]
  def deleteQualificationType(
      request: zio.aws.mturk.model.DeleteQualificationTypeRequest
  ): IO[AwsError, zio.aws.mturk.model.DeleteQualificationTypeResponse.ReadOnly]
}
object MTurk {
  val live: ZLayer[AwsConfig, java.lang.Throwable, MTurk] = customized(identity)
  def customized(
      customization: MTurkAsyncClientBuilder => MTurkAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, MTurk] = managed(
    customization
  ).toLayer
  def managed(
      customization: MTurkAsyncClientBuilder => MTurkAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, MTurk] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = MTurkAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[MTurkAsyncClient, MTurkAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[MTurkAsyncClient, MTurkAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new MTurkImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class MTurkImpl[R](
      override val api: MTurkAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends MTurk
      with AwsServiceBase[R] {
    override val serviceName: String = "MTurk"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): MTurkImpl[R1] = new MTurkImpl(api, newAspect, r)
    def listReviewableHITs(
        request: zio.aws.mturk.model.ListReviewableHiTsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.mturk.model.ListReviewableHiTsResponse.ReadOnly,
      zio.aws.mturk.model.HIT.ReadOnly
    ]] = asyncPaginatedRequest[
      ListReviewableHiTsRequest,
      ListReviewableHiTsResponse,
      HIT
    ](
      "listReviewableHITs",
      api.listReviewableHITs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.hiTs().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.mturk.model.ListReviewableHiTsResponse.wrap)
          .mapOutput(_.map(item => zio.aws.mturk.model.HIT.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listReviewableHITsPaginated(
        request: zio.aws.mturk.model.ListReviewableHiTsRequest
    ): IO[AwsError, zio.aws.mturk.model.ListReviewableHiTsResponse.ReadOnly] =
      asyncRequestResponse[
        ListReviewableHiTsRequest,
        ListReviewableHiTsResponse
      ]("listReviewableHITs", api.listReviewableHITs)(request.buildAwsValue())
        .map(zio.aws.mturk.model.ListReviewableHiTsResponse.wrap)
        .provideEnvironment(r)
    def listQualificationRequests(
        request: zio.aws.mturk.model.ListQualificationRequestsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.mturk.model.ListQualificationRequestsResponse.ReadOnly,
      zio.aws.mturk.model.QualificationRequest.ReadOnly
    ]] = asyncPaginatedRequest[
      ListQualificationRequestsRequest,
      ListQualificationRequestsResponse,
      QualificationRequest
    ](
      "listQualificationRequests",
      api.listQualificationRequests,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.qualificationRequests().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.mturk.model.ListQualificationRequestsResponse.wrap
          )
          .mapOutput(
            _.map(item => zio.aws.mturk.model.QualificationRequest.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listQualificationRequestsPaginated(
        request: zio.aws.mturk.model.ListQualificationRequestsRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.ListQualificationRequestsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListQualificationRequestsRequest,
      ListQualificationRequestsResponse
    ]("listQualificationRequests", api.listQualificationRequests)(
      request.buildAwsValue()
    ).map(zio.aws.mturk.model.ListQualificationRequestsResponse.wrap)
      .provideEnvironment(r)
    def updateQualificationType(
        request: zio.aws.mturk.model.UpdateQualificationTypeRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.UpdateQualificationTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateQualificationTypeRequest,
      UpdateQualificationTypeResponse
    ]("updateQualificationType", api.updateQualificationType)(
      request.buildAwsValue()
    ).map(zio.aws.mturk.model.UpdateQualificationTypeResponse.wrap)
      .provideEnvironment(r)
    def sendTestEventNotification(
        request: zio.aws.mturk.model.SendTestEventNotificationRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.SendTestEventNotificationResponse.ReadOnly
    ] = asyncRequestResponse[
      SendTestEventNotificationRequest,
      SendTestEventNotificationResponse
    ]("sendTestEventNotification", api.sendTestEventNotification)(
      request.buildAwsValue()
    ).map(zio.aws.mturk.model.SendTestEventNotificationResponse.wrap)
      .provideEnvironment(r)
    def listBonusPayments(
        request: zio.aws.mturk.model.ListBonusPaymentsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.mturk.model.ListBonusPaymentsResponse.ReadOnly,
      zio.aws.mturk.model.BonusPayment.ReadOnly
    ]] = asyncPaginatedRequest[
      ListBonusPaymentsRequest,
      ListBonusPaymentsResponse,
      BonusPayment
    ](
      "listBonusPayments",
      api.listBonusPayments,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.bonusPayments().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.mturk.model.ListBonusPaymentsResponse.wrap)
          .mapOutput(_.map(item => zio.aws.mturk.model.BonusPayment.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listBonusPaymentsPaginated(
        request: zio.aws.mturk.model.ListBonusPaymentsRequest
    ): IO[AwsError, zio.aws.mturk.model.ListBonusPaymentsResponse.ReadOnly] =
      asyncRequestResponse[ListBonusPaymentsRequest, ListBonusPaymentsResponse](
        "listBonusPayments",
        api.listBonusPayments
      )(request.buildAwsValue())
        .map(zio.aws.mturk.model.ListBonusPaymentsResponse.wrap)
        .provideEnvironment(r)
    def listQualificationTypes(
        request: zio.aws.mturk.model.ListQualificationTypesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.mturk.model.ListQualificationTypesResponse.ReadOnly,
      zio.aws.mturk.model.QualificationType.ReadOnly
    ]] = asyncPaginatedRequest[
      ListQualificationTypesRequest,
      ListQualificationTypesResponse,
      QualificationType
    ](
      "listQualificationTypes",
      api.listQualificationTypes,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.qualificationTypes().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.mturk.model.ListQualificationTypesResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.mturk.model.QualificationType.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listQualificationTypesPaginated(
        request: zio.aws.mturk.model.ListQualificationTypesRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.ListQualificationTypesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListQualificationTypesRequest,
      ListQualificationTypesResponse
    ]("listQualificationTypes", api.listQualificationTypes)(
      request.buildAwsValue()
    ).map(zio.aws.mturk.model.ListQualificationTypesResponse.wrap)
      .provideEnvironment(r)
    def getHIT(
        request: zio.aws.mturk.model.GetHitRequest
    ): IO[AwsError, zio.aws.mturk.model.GetHitResponse.ReadOnly] =
      asyncRequestResponse[GetHitRequest, GetHitResponse]("getHIT", api.getHIT)(
        request.buildAwsValue()
      ).map(zio.aws.mturk.model.GetHitResponse.wrap).provideEnvironment(r)
    def createQualificationType(
        request: zio.aws.mturk.model.CreateQualificationTypeRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.CreateQualificationTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateQualificationTypeRequest,
      CreateQualificationTypeResponse
    ]("createQualificationType", api.createQualificationType)(
      request.buildAwsValue()
    ).map(zio.aws.mturk.model.CreateQualificationTypeResponse.wrap)
      .provideEnvironment(r)
    def listReviewPolicyResultsForHIT(
        request: zio.aws.mturk.model.ListReviewPolicyResultsForHitRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse.ReadOnly,
      EntityId
    ]] = asyncPaginatedRequest[
      ListReviewPolicyResultsForHitRequest,
      ListReviewPolicyResultsForHitResponse,
      java.lang.String
    ](
      "listReviewPolicyResultsForHIT",
      api.listReviewPolicyResultsForHIT,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk(r.hitId())
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse.wrap
          )
          .mapOutput(
            _.map(item => zio.aws.mturk.model.primitives.EntityId(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listReviewPolicyResultsForHITPaginated(
        request: zio.aws.mturk.model.ListReviewPolicyResultsForHitRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse.ReadOnly
    ] = asyncRequestResponse[
      ListReviewPolicyResultsForHitRequest,
      ListReviewPolicyResultsForHitResponse
    ]("listReviewPolicyResultsForHIT", api.listReviewPolicyResultsForHIT)(
      request.buildAwsValue()
    ).map(zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse.wrap)
      .provideEnvironment(r)
    def deleteWorkerBlock(
        request: zio.aws.mturk.model.DeleteWorkerBlockRequest
    ): IO[AwsError, zio.aws.mturk.model.DeleteWorkerBlockResponse.ReadOnly] =
      asyncRequestResponse[DeleteWorkerBlockRequest, DeleteWorkerBlockResponse](
        "deleteWorkerBlock",
        api.deleteWorkerBlock
      )(request.buildAwsValue())
        .map(zio.aws.mturk.model.DeleteWorkerBlockResponse.wrap)
        .provideEnvironment(r)
    def listHITsForQualificationType(
        request: zio.aws.mturk.model.ListHiTsForQualificationTypeRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.mturk.model.ListHiTsForQualificationTypeResponse.ReadOnly,
      zio.aws.mturk.model.HIT.ReadOnly
    ]] = asyncPaginatedRequest[
      ListHiTsForQualificationTypeRequest,
      ListHiTsForQualificationTypeResponse,
      HIT
    ](
      "listHITsForQualificationType",
      api.listHITsForQualificationType,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.hiTs().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.mturk.model.ListHiTsForQualificationTypeResponse.wrap
          )
          .mapOutput(_.map(item => zio.aws.mturk.model.HIT.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listHITsForQualificationTypePaginated(
        request: zio.aws.mturk.model.ListHiTsForQualificationTypeRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.ListHiTsForQualificationTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      ListHiTsForQualificationTypeRequest,
      ListHiTsForQualificationTypeResponse
    ]("listHITsForQualificationType", api.listHITsForQualificationType)(
      request.buildAwsValue()
    ).map(zio.aws.mturk.model.ListHiTsForQualificationTypeResponse.wrap)
      .provideEnvironment(r)
    def rejectQualificationRequest(
        request: zio.aws.mturk.model.RejectQualificationRequestRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.RejectQualificationRequestResponse.ReadOnly
    ] = asyncRequestResponse[
      RejectQualificationRequestRequest,
      RejectQualificationRequestResponse
    ]("rejectQualificationRequest", api.rejectQualificationRequest)(
      request.buildAwsValue()
    ).map(zio.aws.mturk.model.RejectQualificationRequestResponse.wrap)
      .provideEnvironment(r)
    def acceptQualificationRequest(
        request: zio.aws.mturk.model.AcceptQualificationRequestRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.AcceptQualificationRequestResponse.ReadOnly
    ] = asyncRequestResponse[
      AcceptQualificationRequestRequest,
      AcceptQualificationRequestResponse
    ]("acceptQualificationRequest", api.acceptQualificationRequest)(
      request.buildAwsValue()
    ).map(zio.aws.mturk.model.AcceptQualificationRequestResponse.wrap)
      .provideEnvironment(r)
    def deleteHIT(
        request: zio.aws.mturk.model.DeleteHitRequest
    ): IO[AwsError, zio.aws.mturk.model.DeleteHitResponse.ReadOnly] =
      asyncRequestResponse[DeleteHitRequest, DeleteHitResponse](
        "deleteHIT",
        api.deleteHIT
      )(request.buildAwsValue())
        .map(zio.aws.mturk.model.DeleteHitResponse.wrap)
        .provideEnvironment(r)
    def notifyWorkers(
        request: zio.aws.mturk.model.NotifyWorkersRequest
    ): IO[AwsError, zio.aws.mturk.model.NotifyWorkersResponse.ReadOnly] =
      asyncRequestResponse[NotifyWorkersRequest, NotifyWorkersResponse](
        "notifyWorkers",
        api.notifyWorkers
      )(request.buildAwsValue())
        .map(zio.aws.mturk.model.NotifyWorkersResponse.wrap)
        .provideEnvironment(r)
    def getQualificationScore(
        request: zio.aws.mturk.model.GetQualificationScoreRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.GetQualificationScoreResponse.ReadOnly
    ] = asyncRequestResponse[
      GetQualificationScoreRequest,
      GetQualificationScoreResponse
    ]("getQualificationScore", api.getQualificationScore)(
      request.buildAwsValue()
    ).map(zio.aws.mturk.model.GetQualificationScoreResponse.wrap)
      .provideEnvironment(r)
    def createHITType(
        request: zio.aws.mturk.model.CreateHitTypeRequest
    ): IO[AwsError, zio.aws.mturk.model.CreateHitTypeResponse.ReadOnly] =
      asyncRequestResponse[CreateHitTypeRequest, CreateHitTypeResponse](
        "createHITType",
        api.createHITType
      )(request.buildAwsValue())
        .map(zio.aws.mturk.model.CreateHitTypeResponse.wrap)
        .provideEnvironment(r)
    def updateNotificationSettings(
        request: zio.aws.mturk.model.UpdateNotificationSettingsRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.UpdateNotificationSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateNotificationSettingsRequest,
      UpdateNotificationSettingsResponse
    ]("updateNotificationSettings", api.updateNotificationSettings)(
      request.buildAwsValue()
    ).map(zio.aws.mturk.model.UpdateNotificationSettingsResponse.wrap)
      .provideEnvironment(r)
    def listWorkerBlocks(
        request: zio.aws.mturk.model.ListWorkerBlocksRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.mturk.model.ListWorkerBlocksResponse.ReadOnly,
      zio.aws.mturk.model.WorkerBlock.ReadOnly
    ]] = asyncPaginatedRequest[
      ListWorkerBlocksRequest,
      ListWorkerBlocksResponse,
      WorkerBlock
    ](
      "listWorkerBlocks",
      api.listWorkerBlocks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.workerBlocks().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.mturk.model.ListWorkerBlocksResponse.wrap)
          .mapOutput(_.map(item => zio.aws.mturk.model.WorkerBlock.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listWorkerBlocksPaginated(
        request: zio.aws.mturk.model.ListWorkerBlocksRequest
    ): IO[AwsError, zio.aws.mturk.model.ListWorkerBlocksResponse.ReadOnly] =
      asyncRequestResponse[ListWorkerBlocksRequest, ListWorkerBlocksResponse](
        "listWorkerBlocks",
        api.listWorkerBlocks
      )(request.buildAwsValue())
        .map(zio.aws.mturk.model.ListWorkerBlocksResponse.wrap)
        .provideEnvironment(r)
    def disassociateQualificationFromWorker(
        request: zio.aws.mturk.model.DisassociateQualificationFromWorkerRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.DisassociateQualificationFromWorkerResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateQualificationFromWorkerRequest,
      DisassociateQualificationFromWorkerResponse
    ](
      "disassociateQualificationFromWorker",
      api.disassociateQualificationFromWorker
    )(request.buildAwsValue())
      .map(zio.aws.mturk.model.DisassociateQualificationFromWorkerResponse.wrap)
      .provideEnvironment(r)
    def getQualificationType(
        request: zio.aws.mturk.model.GetQualificationTypeRequest
    ): IO[AwsError, zio.aws.mturk.model.GetQualificationTypeResponse.ReadOnly] =
      asyncRequestResponse[
        GetQualificationTypeRequest,
        GetQualificationTypeResponse
      ]("getQualificationType", api.getQualificationType)(
        request.buildAwsValue()
      ).map(zio.aws.mturk.model.GetQualificationTypeResponse.wrap)
        .provideEnvironment(r)
    def listHITs(
        request: zio.aws.mturk.model.ListHiTsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.mturk.model.ListHiTsResponse.ReadOnly,
      zio.aws.mturk.model.HIT.ReadOnly
    ]] = asyncPaginatedRequest[ListHiTsRequest, ListHiTsResponse, HIT](
      "listHITs",
      api.listHITs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.hiTs().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.mturk.model.ListHiTsResponse.wrap)
          .mapOutput(_.map(item => zio.aws.mturk.model.HIT.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listHITsPaginated(
        request: zio.aws.mturk.model.ListHiTsRequest
    ): IO[AwsError, zio.aws.mturk.model.ListHiTsResponse.ReadOnly] =
      asyncRequestResponse[ListHiTsRequest, ListHiTsResponse](
        "listHITs",
        api.listHITs
      )(request.buildAwsValue())
        .map(zio.aws.mturk.model.ListHiTsResponse.wrap)
        .provideEnvironment(r)
    def getFileUploadURL(
        request: zio.aws.mturk.model.GetFileUploadUrlRequest
    ): IO[AwsError, zio.aws.mturk.model.GetFileUploadUrlResponse.ReadOnly] =
      asyncRequestResponse[GetFileUploadUrlRequest, GetFileUploadUrlResponse](
        "getFileUploadURL",
        api.getFileUploadURL
      )(request.buildAwsValue())
        .map(zio.aws.mturk.model.GetFileUploadUrlResponse.wrap)
        .provideEnvironment(r)
    def listAssignmentsForHIT(
        request: zio.aws.mturk.model.ListAssignmentsForHitRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.mturk.model.ListAssignmentsForHitResponse.ReadOnly,
      zio.aws.mturk.model.Assignment.ReadOnly
    ]] = asyncPaginatedRequest[
      ListAssignmentsForHitRequest,
      ListAssignmentsForHitResponse,
      Assignment
    ](
      "listAssignmentsForHIT",
      api.listAssignmentsForHIT,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.assignments().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.mturk.model.ListAssignmentsForHitResponse.wrap)
          .mapOutput(_.map(item => zio.aws.mturk.model.Assignment.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listAssignmentsForHITPaginated(
        request: zio.aws.mturk.model.ListAssignmentsForHitRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.ListAssignmentsForHitResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAssignmentsForHitRequest,
      ListAssignmentsForHitResponse
    ]("listAssignmentsForHIT", api.listAssignmentsForHIT)(
      request.buildAwsValue()
    ).map(zio.aws.mturk.model.ListAssignmentsForHitResponse.wrap)
      .provideEnvironment(r)
    def getAssignment(
        request: zio.aws.mturk.model.GetAssignmentRequest
    ): IO[AwsError, zio.aws.mturk.model.GetAssignmentResponse.ReadOnly] =
      asyncRequestResponse[GetAssignmentRequest, GetAssignmentResponse](
        "getAssignment",
        api.getAssignment
      )(request.buildAwsValue())
        .map(zio.aws.mturk.model.GetAssignmentResponse.wrap)
        .provideEnvironment(r)
    def associateQualificationWithWorker(
        request: zio.aws.mturk.model.AssociateQualificationWithWorkerRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.AssociateQualificationWithWorkerResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateQualificationWithWorkerRequest,
      AssociateQualificationWithWorkerResponse
    ]("associateQualificationWithWorker", api.associateQualificationWithWorker)(
      request.buildAwsValue()
    ).map(zio.aws.mturk.model.AssociateQualificationWithWorkerResponse.wrap)
      .provideEnvironment(r)
    def updateHITReviewStatus(
        request: zio.aws.mturk.model.UpdateHitReviewStatusRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.UpdateHitReviewStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateHitReviewStatusRequest,
      UpdateHitReviewStatusResponse
    ]("updateHITReviewStatus", api.updateHITReviewStatus)(
      request.buildAwsValue()
    ).map(zio.aws.mturk.model.UpdateHitReviewStatusResponse.wrap)
      .provideEnvironment(r)
    def createHITWithHITType(
        request: zio.aws.mturk.model.CreateHitWithHitTypeRequest
    ): IO[AwsError, zio.aws.mturk.model.CreateHitWithHitTypeResponse.ReadOnly] =
      asyncRequestResponse[
        CreateHitWithHitTypeRequest,
        CreateHitWithHitTypeResponse
      ]("createHITWithHITType", api.createHITWithHITType)(
        request.buildAwsValue()
      ).map(zio.aws.mturk.model.CreateHitWithHitTypeResponse.wrap)
        .provideEnvironment(r)
    def updateHITTypeOfHIT(
        request: zio.aws.mturk.model.UpdateHitTypeOfHitRequest
    ): IO[AwsError, zio.aws.mturk.model.UpdateHitTypeOfHitResponse.ReadOnly] =
      asyncRequestResponse[
        UpdateHitTypeOfHitRequest,
        UpdateHitTypeOfHitResponse
      ]("updateHITTypeOfHIT", api.updateHITTypeOfHIT)(request.buildAwsValue())
        .map(zio.aws.mturk.model.UpdateHitTypeOfHitResponse.wrap)
        .provideEnvironment(r)
    def createAdditionalAssignmentsForHIT(
        request: zio.aws.mturk.model.CreateAdditionalAssignmentsForHitRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.CreateAdditionalAssignmentsForHitResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateAdditionalAssignmentsForHitRequest,
      CreateAdditionalAssignmentsForHitResponse
    ](
      "createAdditionalAssignmentsForHIT",
      api.createAdditionalAssignmentsForHIT
    )(request.buildAwsValue())
      .map(zio.aws.mturk.model.CreateAdditionalAssignmentsForHitResponse.wrap)
      .provideEnvironment(r)
    def createWorkerBlock(
        request: zio.aws.mturk.model.CreateWorkerBlockRequest
    ): IO[AwsError, zio.aws.mturk.model.CreateWorkerBlockResponse.ReadOnly] =
      asyncRequestResponse[CreateWorkerBlockRequest, CreateWorkerBlockResponse](
        "createWorkerBlock",
        api.createWorkerBlock
      )(request.buildAwsValue())
        .map(zio.aws.mturk.model.CreateWorkerBlockResponse.wrap)
        .provideEnvironment(r)
    def approveAssignment(
        request: zio.aws.mturk.model.ApproveAssignmentRequest
    ): IO[AwsError, zio.aws.mturk.model.ApproveAssignmentResponse.ReadOnly] =
      asyncRequestResponse[ApproveAssignmentRequest, ApproveAssignmentResponse](
        "approveAssignment",
        api.approveAssignment
      )(request.buildAwsValue())
        .map(zio.aws.mturk.model.ApproveAssignmentResponse.wrap)
        .provideEnvironment(r)
    def getAccountBalance(
        request: zio.aws.mturk.model.GetAccountBalanceRequest
    ): IO[AwsError, zio.aws.mturk.model.GetAccountBalanceResponse.ReadOnly] =
      asyncRequestResponse[GetAccountBalanceRequest, GetAccountBalanceResponse](
        "getAccountBalance",
        api.getAccountBalance
      )(request.buildAwsValue())
        .map(zio.aws.mturk.model.GetAccountBalanceResponse.wrap)
        .provideEnvironment(r)
    def listWorkersWithQualificationType(
        request: zio.aws.mturk.model.ListWorkersWithQualificationTypeRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.mturk.model.ListWorkersWithQualificationTypeResponse.ReadOnly,
      zio.aws.mturk.model.Qualification.ReadOnly
    ]] = asyncPaginatedRequest[
      ListWorkersWithQualificationTypeRequest,
      ListWorkersWithQualificationTypeResponse,
      Qualification
    ](
      "listWorkersWithQualificationType",
      api.listWorkersWithQualificationType,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.qualifications().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.mturk.model.ListWorkersWithQualificationTypeResponse.wrap
          )
          .mapOutput(
            _.map(item => zio.aws.mturk.model.Qualification.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listWorkersWithQualificationTypePaginated(
        request: zio.aws.mturk.model.ListWorkersWithQualificationTypeRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.ListWorkersWithQualificationTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      ListWorkersWithQualificationTypeRequest,
      ListWorkersWithQualificationTypeResponse
    ]("listWorkersWithQualificationType", api.listWorkersWithQualificationType)(
      request.buildAwsValue()
    ).map(zio.aws.mturk.model.ListWorkersWithQualificationTypeResponse.wrap)
      .provideEnvironment(r)
    def createHIT(
        request: zio.aws.mturk.model.CreateHitRequest
    ): IO[AwsError, zio.aws.mturk.model.CreateHitResponse.ReadOnly] =
      asyncRequestResponse[CreateHitRequest, CreateHitResponse](
        "createHIT",
        api.createHIT
      )(request.buildAwsValue())
        .map(zio.aws.mturk.model.CreateHitResponse.wrap)
        .provideEnvironment(r)
    def sendBonus(
        request: zio.aws.mturk.model.SendBonusRequest
    ): IO[AwsError, zio.aws.mturk.model.SendBonusResponse.ReadOnly] =
      asyncRequestResponse[SendBonusRequest, SendBonusResponse](
        "sendBonus",
        api.sendBonus
      )(request.buildAwsValue())
        .map(zio.aws.mturk.model.SendBonusResponse.wrap)
        .provideEnvironment(r)
    def updateExpirationForHIT(
        request: zio.aws.mturk.model.UpdateExpirationForHitRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.UpdateExpirationForHitResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateExpirationForHitRequest,
      UpdateExpirationForHitResponse
    ]("updateExpirationForHIT", api.updateExpirationForHIT)(
      request.buildAwsValue()
    ).map(zio.aws.mturk.model.UpdateExpirationForHitResponse.wrap)
      .provideEnvironment(r)
    def rejectAssignment(
        request: zio.aws.mturk.model.RejectAssignmentRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[RejectAssignmentRequest, RejectAssignmentResponse](
        "rejectAssignment",
        api.rejectAssignment
      )(request.buildAwsValue())
        .map(zio.aws.mturk.model.RejectAssignmentResponse.wrap)
        .provideEnvironment(r)
    def deleteQualificationType(
        request: zio.aws.mturk.model.DeleteQualificationTypeRequest
    ): IO[
      AwsError,
      zio.aws.mturk.model.DeleteQualificationTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteQualificationTypeRequest,
      DeleteQualificationTypeResponse
    ]("deleteQualificationType", api.deleteQualificationType)(
      request.buildAwsValue()
    ).map(zio.aws.mturk.model.DeleteQualificationTypeResponse.wrap)
      .provideEnvironment(r)
  }
  def listReviewableHITs(
      request: zio.aws.mturk.model.ListReviewableHiTsRequest
  ): ZIO[zio.aws.mturk.MTurk, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListReviewableHiTsResponse.ReadOnly,
    zio.aws.mturk.model.HIT.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listReviewableHITs(request))
  def listReviewableHITsPaginated(
      request: zio.aws.mturk.model.ListReviewableHiTsRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.ListReviewableHiTsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReviewableHITsPaginated(request))
  def listQualificationRequests(
      request: zio.aws.mturk.model.ListQualificationRequestsRequest
  ): ZIO[zio.aws.mturk.MTurk, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListQualificationRequestsResponse.ReadOnly,
    zio.aws.mturk.model.QualificationRequest.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listQualificationRequests(request))
  def listQualificationRequestsPaginated(
      request: zio.aws.mturk.model.ListQualificationRequestsRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.ListQualificationRequestsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listQualificationRequestsPaginated(request))
  def updateQualificationType(
      request: zio.aws.mturk.model.UpdateQualificationTypeRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.UpdateQualificationTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateQualificationType(request))
  def sendTestEventNotification(
      request: zio.aws.mturk.model.SendTestEventNotificationRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.SendTestEventNotificationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendTestEventNotification(request))
  def listBonusPayments(
      request: zio.aws.mturk.model.ListBonusPaymentsRequest
  ): ZIO[zio.aws.mturk.MTurk, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListBonusPaymentsResponse.ReadOnly,
    zio.aws.mturk.model.BonusPayment.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listBonusPayments(request))
  def listBonusPaymentsPaginated(
      request: zio.aws.mturk.model.ListBonusPaymentsRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.ListBonusPaymentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBonusPaymentsPaginated(request))
  def listQualificationTypes(
      request: zio.aws.mturk.model.ListQualificationTypesRequest
  ): ZIO[zio.aws.mturk.MTurk, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListQualificationTypesResponse.ReadOnly,
    zio.aws.mturk.model.QualificationType.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listQualificationTypes(request))
  def listQualificationTypesPaginated(
      request: zio.aws.mturk.model.ListQualificationTypesRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.ListQualificationTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listQualificationTypesPaginated(request))
  def getHIT(request: zio.aws.mturk.model.GetHitRequest): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.GetHitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getHIT(request))
  def createQualificationType(
      request: zio.aws.mturk.model.CreateQualificationTypeRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.CreateQualificationTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createQualificationType(request))
  def listReviewPolicyResultsForHIT(
      request: zio.aws.mturk.model.ListReviewPolicyResultsForHitRequest
  ): ZIO[zio.aws.mturk.MTurk, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse.ReadOnly,
    EntityId
  ]] = ZIO.serviceWithZIO(_.listReviewPolicyResultsForHIT(request))
  def listReviewPolicyResultsForHITPaginated(
      request: zio.aws.mturk.model.ListReviewPolicyResultsForHitRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReviewPolicyResultsForHITPaginated(request))
  def deleteWorkerBlock(
      request: zio.aws.mturk.model.DeleteWorkerBlockRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.DeleteWorkerBlockResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorkerBlock(request))
  def listHITsForQualificationType(
      request: zio.aws.mturk.model.ListHiTsForQualificationTypeRequest
  ): ZIO[zio.aws.mturk.MTurk, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListHiTsForQualificationTypeResponse.ReadOnly,
    zio.aws.mturk.model.HIT.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listHITsForQualificationType(request))
  def listHITsForQualificationTypePaginated(
      request: zio.aws.mturk.model.ListHiTsForQualificationTypeRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.ListHiTsForQualificationTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listHITsForQualificationTypePaginated(request))
  def rejectQualificationRequest(
      request: zio.aws.mturk.model.RejectQualificationRequestRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.RejectQualificationRequestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rejectQualificationRequest(request))
  def acceptQualificationRequest(
      request: zio.aws.mturk.model.AcceptQualificationRequestRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.AcceptQualificationRequestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptQualificationRequest(request))
  def deleteHIT(request: zio.aws.mturk.model.DeleteHitRequest): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.DeleteHitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteHIT(request))
  def notifyWorkers(request: zio.aws.mturk.model.NotifyWorkersRequest): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.NotifyWorkersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.notifyWorkers(request))
  def getQualificationScore(
      request: zio.aws.mturk.model.GetQualificationScoreRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.GetQualificationScoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getQualificationScore(request))
  def createHITType(request: zio.aws.mturk.model.CreateHitTypeRequest): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.CreateHitTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createHITType(request))
  def updateNotificationSettings(
      request: zio.aws.mturk.model.UpdateNotificationSettingsRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.UpdateNotificationSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNotificationSettings(request))
  def listWorkerBlocks(
      request: zio.aws.mturk.model.ListWorkerBlocksRequest
  ): ZIO[zio.aws.mturk.MTurk, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListWorkerBlocksResponse.ReadOnly,
    zio.aws.mturk.model.WorkerBlock.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listWorkerBlocks(request))
  def listWorkerBlocksPaginated(
      request: zio.aws.mturk.model.ListWorkerBlocksRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.ListWorkerBlocksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkerBlocksPaginated(request))
  def disassociateQualificationFromWorker(
      request: zio.aws.mturk.model.DisassociateQualificationFromWorkerRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.DisassociateQualificationFromWorkerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateQualificationFromWorker(request))
  def getQualificationType(
      request: zio.aws.mturk.model.GetQualificationTypeRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.GetQualificationTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getQualificationType(request))
  def listHITs(
      request: zio.aws.mturk.model.ListHiTsRequest
  ): ZIO[zio.aws.mturk.MTurk, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListHiTsResponse.ReadOnly,
    zio.aws.mturk.model.HIT.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listHITs(request))
  def listHITsPaginated(request: zio.aws.mturk.model.ListHiTsRequest): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.ListHiTsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listHITsPaginated(request))
  def getFileUploadURL(
      request: zio.aws.mturk.model.GetFileUploadUrlRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.GetFileUploadUrlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFileUploadURL(request))
  def listAssignmentsForHIT(
      request: zio.aws.mturk.model.ListAssignmentsForHitRequest
  ): ZIO[zio.aws.mturk.MTurk, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListAssignmentsForHitResponse.ReadOnly,
    zio.aws.mturk.model.Assignment.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listAssignmentsForHIT(request))
  def listAssignmentsForHITPaginated(
      request: zio.aws.mturk.model.ListAssignmentsForHitRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.ListAssignmentsForHitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssignmentsForHITPaginated(request))
  def getAssignment(request: zio.aws.mturk.model.GetAssignmentRequest): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.GetAssignmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAssignment(request))
  def associateQualificationWithWorker(
      request: zio.aws.mturk.model.AssociateQualificationWithWorkerRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.AssociateQualificationWithWorkerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateQualificationWithWorker(request))
  def updateHITReviewStatus(
      request: zio.aws.mturk.model.UpdateHitReviewStatusRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.UpdateHitReviewStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateHITReviewStatus(request))
  def createHITWithHITType(
      request: zio.aws.mturk.model.CreateHitWithHitTypeRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.CreateHitWithHitTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createHITWithHITType(request))
  def updateHITTypeOfHIT(
      request: zio.aws.mturk.model.UpdateHitTypeOfHitRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.UpdateHitTypeOfHitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateHITTypeOfHIT(request))
  def createAdditionalAssignmentsForHIT(
      request: zio.aws.mturk.model.CreateAdditionalAssignmentsForHitRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.CreateAdditionalAssignmentsForHitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAdditionalAssignmentsForHIT(request))
  def createWorkerBlock(
      request: zio.aws.mturk.model.CreateWorkerBlockRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.CreateWorkerBlockResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkerBlock(request))
  def approveAssignment(
      request: zio.aws.mturk.model.ApproveAssignmentRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.ApproveAssignmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.approveAssignment(request))
  def getAccountBalance(
      request: zio.aws.mturk.model.GetAccountBalanceRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.GetAccountBalanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccountBalance(request))
  def listWorkersWithQualificationType(
      request: zio.aws.mturk.model.ListWorkersWithQualificationTypeRequest
  ): ZIO[zio.aws.mturk.MTurk, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mturk.model.ListWorkersWithQualificationTypeResponse.ReadOnly,
    zio.aws.mturk.model.Qualification.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listWorkersWithQualificationType(request))
  def listWorkersWithQualificationTypePaginated(
      request: zio.aws.mturk.model.ListWorkersWithQualificationTypeRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.ListWorkersWithQualificationTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkersWithQualificationTypePaginated(request))
  def createHIT(request: zio.aws.mturk.model.CreateHitRequest): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.CreateHitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createHIT(request))
  def sendBonus(request: zio.aws.mturk.model.SendBonusRequest): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.SendBonusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendBonus(request))
  def updateExpirationForHIT(
      request: zio.aws.mturk.model.UpdateExpirationForHitRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.UpdateExpirationForHitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateExpirationForHIT(request))
  def rejectAssignment(
      request: zio.aws.mturk.model.RejectAssignmentRequest
  ): ZIO[zio.aws.mturk.MTurk, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.rejectAssignment(request))
  def deleteQualificationType(
      request: zio.aws.mturk.model.DeleteQualificationTypeRequest
  ): ZIO[
    zio.aws.mturk.MTurk,
    AwsError,
    zio.aws.mturk.model.DeleteQualificationTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteQualificationType(request))
}
