package zio.aws.mturk
import zio.aws.mturk.model.RejectAssignmentResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.mturk.MTurkAsyncClient
import zio.aws.mturk.model.primitives.EntityId
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZIO, ZEnvironment, URLayer}
import zio.aws.mturk.model.{
  ListAssignmentsForHitRequest,
  CreateAdditionalAssignmentsForHitRequest,
  NotifyWorkersRequest,
  CreateQualificationTypeRequest,
  SendTestEventNotificationRequest,
  UpdateExpirationForHitRequest,
  ListReviewPolicyResultsForHitRequest,
  DeleteWorkerBlockRequest,
  ListQualificationRequestsRequest,
  GetHitRequest,
  GetQualificationTypeRequest,
  ApproveAssignmentRequest,
  CreateHitWithHitTypeRequest,
  CreateHitTypeRequest,
  AcceptQualificationRequestRequest,
  UpdateQualificationTypeRequest,
  UpdateHitReviewStatusRequest,
  CreateHitRequest,
  SendBonusRequest,
  GetQualificationScoreRequest,
  GetFileUploadUrlRequest,
  GetAssignmentRequest,
  ListQualificationTypesRequest,
  DeleteHitRequest,
  ListWorkersWithQualificationTypeRequest,
  ListBonusPaymentsRequest,
  CreateWorkerBlockRequest,
  GetAccountBalanceRequest,
  RejectAssignmentRequest,
  DeleteQualificationTypeRequest,
  AssociateQualificationWithWorkerRequest,
  DisassociateQualificationFromWorkerRequest,
  ListHiTsRequest,
  ListReviewableHiTsRequest,
  ListWorkerBlocksRequest,
  ListHiTsForQualificationTypeRequest,
  RejectQualificationRequestRequest,
  UpdateNotificationSettingsRequest,
  UpdateHitTypeOfHitRequest
}
object MTurkMock extends Mock[MTurk] {
  object ListReviewableHITs
      extends Effect[ListReviewableHiTsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.mturk.model.ListReviewableHiTsResponse.ReadOnly,
        zio.aws.mturk.model.HIT.ReadOnly
      ]]
  object ListReviewableHITsPaginated
      extends Effect[
        ListReviewableHiTsRequest,
        AwsError,
        zio.aws.mturk.model.ListReviewableHiTsResponse.ReadOnly
      ]
  object ListQualificationRequests
      extends Effect[
        ListQualificationRequestsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.mturk.model.ListQualificationRequestsResponse.ReadOnly,
          zio.aws.mturk.model.QualificationRequest.ReadOnly
        ]
      ]
  object ListQualificationRequestsPaginated
      extends Effect[
        ListQualificationRequestsRequest,
        AwsError,
        zio.aws.mturk.model.ListQualificationRequestsResponse.ReadOnly
      ]
  object UpdateQualificationType
      extends Effect[
        UpdateQualificationTypeRequest,
        AwsError,
        zio.aws.mturk.model.UpdateQualificationTypeResponse.ReadOnly
      ]
  object SendTestEventNotification
      extends Effect[
        SendTestEventNotificationRequest,
        AwsError,
        zio.aws.mturk.model.SendTestEventNotificationResponse.ReadOnly
      ]
  object ListBonusPayments
      extends Effect[ListBonusPaymentsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.mturk.model.ListBonusPaymentsResponse.ReadOnly,
        zio.aws.mturk.model.BonusPayment.ReadOnly
      ]]
  object ListBonusPaymentsPaginated
      extends Effect[
        ListBonusPaymentsRequest,
        AwsError,
        zio.aws.mturk.model.ListBonusPaymentsResponse.ReadOnly
      ]
  object ListQualificationTypes
      extends Effect[
        ListQualificationTypesRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.mturk.model.ListQualificationTypesResponse.ReadOnly,
          zio.aws.mturk.model.QualificationType.ReadOnly
        ]
      ]
  object ListQualificationTypesPaginated
      extends Effect[
        ListQualificationTypesRequest,
        AwsError,
        zio.aws.mturk.model.ListQualificationTypesResponse.ReadOnly
      ]
  object GetHIT
      extends Effect[
        GetHitRequest,
        AwsError,
        zio.aws.mturk.model.GetHitResponse.ReadOnly
      ]
  object CreateQualificationType
      extends Effect[
        CreateQualificationTypeRequest,
        AwsError,
        zio.aws.mturk.model.CreateQualificationTypeResponse.ReadOnly
      ]
  object ListReviewPolicyResultsForHIT
      extends Effect[
        ListReviewPolicyResultsForHitRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse.ReadOnly,
          EntityId
        ]
      ]
  object ListReviewPolicyResultsForHITPaginated
      extends Effect[
        ListReviewPolicyResultsForHitRequest,
        AwsError,
        zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse.ReadOnly
      ]
  object DeleteWorkerBlock
      extends Effect[
        DeleteWorkerBlockRequest,
        AwsError,
        zio.aws.mturk.model.DeleteWorkerBlockResponse.ReadOnly
      ]
  object ListHITsForQualificationType
      extends Effect[
        ListHiTsForQualificationTypeRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.mturk.model.ListHiTsForQualificationTypeResponse.ReadOnly,
          zio.aws.mturk.model.HIT.ReadOnly
        ]
      ]
  object ListHITsForQualificationTypePaginated
      extends Effect[
        ListHiTsForQualificationTypeRequest,
        AwsError,
        zio.aws.mturk.model.ListHiTsForQualificationTypeResponse.ReadOnly
      ]
  object RejectQualificationRequest
      extends Effect[
        RejectQualificationRequestRequest,
        AwsError,
        zio.aws.mturk.model.RejectQualificationRequestResponse.ReadOnly
      ]
  object AcceptQualificationRequest
      extends Effect[
        AcceptQualificationRequestRequest,
        AwsError,
        zio.aws.mturk.model.AcceptQualificationRequestResponse.ReadOnly
      ]
  object DeleteHIT
      extends Effect[
        DeleteHitRequest,
        AwsError,
        zio.aws.mturk.model.DeleteHitResponse.ReadOnly
      ]
  object NotifyWorkers
      extends Effect[
        NotifyWorkersRequest,
        AwsError,
        zio.aws.mturk.model.NotifyWorkersResponse.ReadOnly
      ]
  object GetQualificationScore
      extends Effect[
        GetQualificationScoreRequest,
        AwsError,
        zio.aws.mturk.model.GetQualificationScoreResponse.ReadOnly
      ]
  object CreateHITType
      extends Effect[
        CreateHitTypeRequest,
        AwsError,
        zio.aws.mturk.model.CreateHitTypeResponse.ReadOnly
      ]
  object UpdateNotificationSettings
      extends Effect[
        UpdateNotificationSettingsRequest,
        AwsError,
        zio.aws.mturk.model.UpdateNotificationSettingsResponse.ReadOnly
      ]
  object ListWorkerBlocks
      extends Effect[ListWorkerBlocksRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.mturk.model.ListWorkerBlocksResponse.ReadOnly,
        zio.aws.mturk.model.WorkerBlock.ReadOnly
      ]]
  object ListWorkerBlocksPaginated
      extends Effect[
        ListWorkerBlocksRequest,
        AwsError,
        zio.aws.mturk.model.ListWorkerBlocksResponse.ReadOnly
      ]
  object DisassociateQualificationFromWorker
      extends Effect[
        DisassociateQualificationFromWorkerRequest,
        AwsError,
        zio.aws.mturk.model.DisassociateQualificationFromWorkerResponse.ReadOnly
      ]
  object GetQualificationType
      extends Effect[
        GetQualificationTypeRequest,
        AwsError,
        zio.aws.mturk.model.GetQualificationTypeResponse.ReadOnly
      ]
  object ListHITs
      extends Effect[ListHiTsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.mturk.model.ListHiTsResponse.ReadOnly,
        zio.aws.mturk.model.HIT.ReadOnly
      ]]
  object ListHITsPaginated
      extends Effect[
        ListHiTsRequest,
        AwsError,
        zio.aws.mturk.model.ListHiTsResponse.ReadOnly
      ]
  object GetFileUploadURL
      extends Effect[
        GetFileUploadUrlRequest,
        AwsError,
        zio.aws.mturk.model.GetFileUploadUrlResponse.ReadOnly
      ]
  object ListAssignmentsForHIT
      extends Effect[
        ListAssignmentsForHitRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.mturk.model.ListAssignmentsForHitResponse.ReadOnly,
          zio.aws.mturk.model.Assignment.ReadOnly
        ]
      ]
  object ListAssignmentsForHITPaginated
      extends Effect[
        ListAssignmentsForHitRequest,
        AwsError,
        zio.aws.mturk.model.ListAssignmentsForHitResponse.ReadOnly
      ]
  object GetAssignment
      extends Effect[
        GetAssignmentRequest,
        AwsError,
        zio.aws.mturk.model.GetAssignmentResponse.ReadOnly
      ]
  object AssociateQualificationWithWorker
      extends Effect[
        AssociateQualificationWithWorkerRequest,
        AwsError,
        zio.aws.mturk.model.AssociateQualificationWithWorkerResponse.ReadOnly
      ]
  object UpdateHITReviewStatus
      extends Effect[
        UpdateHitReviewStatusRequest,
        AwsError,
        zio.aws.mturk.model.UpdateHitReviewStatusResponse.ReadOnly
      ]
  object CreateHITWithHITType
      extends Effect[
        CreateHitWithHitTypeRequest,
        AwsError,
        zio.aws.mturk.model.CreateHitWithHitTypeResponse.ReadOnly
      ]
  object UpdateHITTypeOfHIT
      extends Effect[
        UpdateHitTypeOfHitRequest,
        AwsError,
        zio.aws.mturk.model.UpdateHitTypeOfHitResponse.ReadOnly
      ]
  object CreateAdditionalAssignmentsForHIT
      extends Effect[
        CreateAdditionalAssignmentsForHitRequest,
        AwsError,
        zio.aws.mturk.model.CreateAdditionalAssignmentsForHitResponse.ReadOnly
      ]
  object CreateWorkerBlock
      extends Effect[
        CreateWorkerBlockRequest,
        AwsError,
        zio.aws.mturk.model.CreateWorkerBlockResponse.ReadOnly
      ]
  object ApproveAssignment
      extends Effect[
        ApproveAssignmentRequest,
        AwsError,
        zio.aws.mturk.model.ApproveAssignmentResponse.ReadOnly
      ]
  object GetAccountBalance
      extends Effect[
        GetAccountBalanceRequest,
        AwsError,
        zio.aws.mturk.model.GetAccountBalanceResponse.ReadOnly
      ]
  object ListWorkersWithQualificationType
      extends Effect[
        ListWorkersWithQualificationTypeRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.mturk.model.ListWorkersWithQualificationTypeResponse.ReadOnly,
          zio.aws.mturk.model.Qualification.ReadOnly
        ]
      ]
  object ListWorkersWithQualificationTypePaginated
      extends Effect[
        ListWorkersWithQualificationTypeRequest,
        AwsError,
        zio.aws.mturk.model.ListWorkersWithQualificationTypeResponse.ReadOnly
      ]
  object CreateHIT
      extends Effect[
        CreateHitRequest,
        AwsError,
        zio.aws.mturk.model.CreateHitResponse.ReadOnly
      ]
  object SendBonus
      extends Effect[
        SendBonusRequest,
        AwsError,
        zio.aws.mturk.model.SendBonusResponse.ReadOnly
      ]
  object UpdateExpirationForHIT
      extends Effect[
        UpdateExpirationForHitRequest,
        AwsError,
        zio.aws.mturk.model.UpdateExpirationForHitResponse.ReadOnly
      ]
  object RejectAssignment
      extends Effect[RejectAssignmentRequest, AwsError, ReadOnly]
  object DeleteQualificationType
      extends Effect[
        DeleteQualificationTypeRequest,
        AwsError,
        zio.aws.mturk.model.DeleteQualificationTypeResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, MTurk] = ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new MTurk {
          val api: MTurkAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : MTurk = this
          def listReviewableHITs(
              request: ListReviewableHiTsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.mturk.model.ListReviewableHiTsResponse.ReadOnly,
            zio.aws.mturk.model.HIT.ReadOnly
          ]] = proxy(ListReviewableHITs, request)
          def listReviewableHITsPaginated(
              request: ListReviewableHiTsRequest
          ): IO[
            AwsError,
            zio.aws.mturk.model.ListReviewableHiTsResponse.ReadOnly
          ] = proxy(ListReviewableHITsPaginated, request)
          def listQualificationRequests(
              request: ListQualificationRequestsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.mturk.model.ListQualificationRequestsResponse.ReadOnly,
            zio.aws.mturk.model.QualificationRequest.ReadOnly
          ]] = proxy(ListQualificationRequests, request)
          def listQualificationRequestsPaginated(
              request: ListQualificationRequestsRequest
          ): IO[
            AwsError,
            zio.aws.mturk.model.ListQualificationRequestsResponse.ReadOnly
          ] = proxy(ListQualificationRequestsPaginated, request)
          def updateQualificationType(
              request: UpdateQualificationTypeRequest
          ): IO[
            AwsError,
            zio.aws.mturk.model.UpdateQualificationTypeResponse.ReadOnly
          ] = proxy(UpdateQualificationType, request)
          def sendTestEventNotification(
              request: SendTestEventNotificationRequest
          ): IO[
            AwsError,
            zio.aws.mturk.model.SendTestEventNotificationResponse.ReadOnly
          ] = proxy(SendTestEventNotification, request)
          def listBonusPayments(
              request: ListBonusPaymentsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.mturk.model.ListBonusPaymentsResponse.ReadOnly,
            zio.aws.mturk.model.BonusPayment.ReadOnly
          ]] = proxy(ListBonusPayments, request)
          def listBonusPaymentsPaginated(request: ListBonusPaymentsRequest): IO[
            AwsError,
            zio.aws.mturk.model.ListBonusPaymentsResponse.ReadOnly
          ] = proxy(ListBonusPaymentsPaginated, request)
          def listQualificationTypes(
              request: ListQualificationTypesRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.mturk.model.ListQualificationTypesResponse.ReadOnly,
            zio.aws.mturk.model.QualificationType.ReadOnly
          ]] = proxy(ListQualificationTypes, request)
          def listQualificationTypesPaginated(
              request: ListQualificationTypesRequest
          ): IO[
            AwsError,
            zio.aws.mturk.model.ListQualificationTypesResponse.ReadOnly
          ] = proxy(ListQualificationTypesPaginated, request)
          def getHIT(
              request: GetHitRequest
          ): IO[AwsError, zio.aws.mturk.model.GetHitResponse.ReadOnly] =
            proxy(GetHIT, request)
          def createQualificationType(
              request: CreateQualificationTypeRequest
          ): IO[
            AwsError,
            zio.aws.mturk.model.CreateQualificationTypeResponse.ReadOnly
          ] = proxy(CreateQualificationType, request)
          def listReviewPolicyResultsForHIT(
              request: ListReviewPolicyResultsForHitRequest
          ): IO[AwsError, StreamingOutputResult[
            Any,
            zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse.ReadOnly,
            EntityId
          ]] = proxy(ListReviewPolicyResultsForHIT, request)
          def listReviewPolicyResultsForHITPaginated(
              request: ListReviewPolicyResultsForHitRequest
          ): IO[
            AwsError,
            zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse.ReadOnly
          ] = proxy(ListReviewPolicyResultsForHITPaginated, request)
          def deleteWorkerBlock(request: DeleteWorkerBlockRequest): IO[
            AwsError,
            zio.aws.mturk.model.DeleteWorkerBlockResponse.ReadOnly
          ] = proxy(DeleteWorkerBlock, request)
          def listHITsForQualificationType(
              request: ListHiTsForQualificationTypeRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.mturk.model.ListHiTsForQualificationTypeResponse.ReadOnly,
            zio.aws.mturk.model.HIT.ReadOnly
          ]] = proxy(ListHITsForQualificationType, request)
          def listHITsForQualificationTypePaginated(
              request: ListHiTsForQualificationTypeRequest
          ): IO[
            AwsError,
            zio.aws.mturk.model.ListHiTsForQualificationTypeResponse.ReadOnly
          ] = proxy(ListHITsForQualificationTypePaginated, request)
          def rejectQualificationRequest(
              request: RejectQualificationRequestRequest
          ): IO[
            AwsError,
            zio.aws.mturk.model.RejectQualificationRequestResponse.ReadOnly
          ] = proxy(RejectQualificationRequest, request)
          def acceptQualificationRequest(
              request: AcceptQualificationRequestRequest
          ): IO[
            AwsError,
            zio.aws.mturk.model.AcceptQualificationRequestResponse.ReadOnly
          ] = proxy(AcceptQualificationRequest, request)
          def deleteHIT(
              request: DeleteHitRequest
          ): IO[AwsError, zio.aws.mturk.model.DeleteHitResponse.ReadOnly] =
            proxy(DeleteHIT, request)
          def notifyWorkers(
              request: NotifyWorkersRequest
          ): IO[AwsError, zio.aws.mturk.model.NotifyWorkersResponse.ReadOnly] =
            proxy(NotifyWorkers, request)
          def getQualificationScore(request: GetQualificationScoreRequest): IO[
            AwsError,
            zio.aws.mturk.model.GetQualificationScoreResponse.ReadOnly
          ] = proxy(GetQualificationScore, request)
          def createHITType(
              request: CreateHitTypeRequest
          ): IO[AwsError, zio.aws.mturk.model.CreateHitTypeResponse.ReadOnly] =
            proxy(CreateHITType, request)
          def updateNotificationSettings(
              request: UpdateNotificationSettingsRequest
          ): IO[
            AwsError,
            zio.aws.mturk.model.UpdateNotificationSettingsResponse.ReadOnly
          ] = proxy(UpdateNotificationSettings, request)
          def listWorkerBlocks(
              request: ListWorkerBlocksRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.mturk.model.ListWorkerBlocksResponse.ReadOnly,
            zio.aws.mturk.model.WorkerBlock.ReadOnly
          ]] = proxy(ListWorkerBlocks, request)
          def listWorkerBlocksPaginated(request: ListWorkerBlocksRequest): IO[
            AwsError,
            zio.aws.mturk.model.ListWorkerBlocksResponse.ReadOnly
          ] = proxy(ListWorkerBlocksPaginated, request)
          def disassociateQualificationFromWorker(
              request: DisassociateQualificationFromWorkerRequest
          ): IO[
            AwsError,
            zio.aws.mturk.model.DisassociateQualificationFromWorkerResponse.ReadOnly
          ] = proxy(DisassociateQualificationFromWorker, request)
          def getQualificationType(request: GetQualificationTypeRequest): IO[
            AwsError,
            zio.aws.mturk.model.GetQualificationTypeResponse.ReadOnly
          ] = proxy(GetQualificationType, request)
          def listHITs(
              request: ListHiTsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.mturk.model.ListHiTsResponse.ReadOnly,
            zio.aws.mturk.model.HIT.ReadOnly
          ]] = proxy(ListHITs, request)
          def listHITsPaginated(
              request: ListHiTsRequest
          ): IO[AwsError, zio.aws.mturk.model.ListHiTsResponse.ReadOnly] =
            proxy(ListHITsPaginated, request)
          def getFileUploadURL(request: GetFileUploadUrlRequest): IO[
            AwsError,
            zio.aws.mturk.model.GetFileUploadUrlResponse.ReadOnly
          ] = proxy(GetFileUploadURL, request)
          def listAssignmentsForHIT(
              request: ListAssignmentsForHitRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.mturk.model.ListAssignmentsForHitResponse.ReadOnly,
            zio.aws.mturk.model.Assignment.ReadOnly
          ]] = proxy(ListAssignmentsForHIT, request)
          def listAssignmentsForHITPaginated(
              request: ListAssignmentsForHitRequest
          ): IO[
            AwsError,
            zio.aws.mturk.model.ListAssignmentsForHitResponse.ReadOnly
          ] = proxy(ListAssignmentsForHITPaginated, request)
          def getAssignment(
              request: GetAssignmentRequest
          ): IO[AwsError, zio.aws.mturk.model.GetAssignmentResponse.ReadOnly] =
            proxy(GetAssignment, request)
          def associateQualificationWithWorker(
              request: AssociateQualificationWithWorkerRequest
          ): IO[
            AwsError,
            zio.aws.mturk.model.AssociateQualificationWithWorkerResponse.ReadOnly
          ] = proxy(AssociateQualificationWithWorker, request)
          def updateHITReviewStatus(request: UpdateHitReviewStatusRequest): IO[
            AwsError,
            zio.aws.mturk.model.UpdateHitReviewStatusResponse.ReadOnly
          ] = proxy(UpdateHITReviewStatus, request)
          def createHITWithHITType(request: CreateHitWithHitTypeRequest): IO[
            AwsError,
            zio.aws.mturk.model.CreateHitWithHitTypeResponse.ReadOnly
          ] = proxy(CreateHITWithHITType, request)
          def updateHITTypeOfHIT(request: UpdateHitTypeOfHitRequest): IO[
            AwsError,
            zio.aws.mturk.model.UpdateHitTypeOfHitResponse.ReadOnly
          ] = proxy(UpdateHITTypeOfHIT, request)
          def createAdditionalAssignmentsForHIT(
              request: CreateAdditionalAssignmentsForHitRequest
          ): IO[
            AwsError,
            zio.aws.mturk.model.CreateAdditionalAssignmentsForHitResponse.ReadOnly
          ] = proxy(CreateAdditionalAssignmentsForHIT, request)
          def createWorkerBlock(request: CreateWorkerBlockRequest): IO[
            AwsError,
            zio.aws.mturk.model.CreateWorkerBlockResponse.ReadOnly
          ] = proxy(CreateWorkerBlock, request)
          def approveAssignment(request: ApproveAssignmentRequest): IO[
            AwsError,
            zio.aws.mturk.model.ApproveAssignmentResponse.ReadOnly
          ] = proxy(ApproveAssignment, request)
          def getAccountBalance(request: GetAccountBalanceRequest): IO[
            AwsError,
            zio.aws.mturk.model.GetAccountBalanceResponse.ReadOnly
          ] = proxy(GetAccountBalance, request)
          def listWorkersWithQualificationType(
              request: ListWorkersWithQualificationTypeRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.mturk.model.ListWorkersWithQualificationTypeResponse.ReadOnly,
            zio.aws.mturk.model.Qualification.ReadOnly
          ]] = proxy(ListWorkersWithQualificationType, request)
          def listWorkersWithQualificationTypePaginated(
              request: ListWorkersWithQualificationTypeRequest
          ): IO[
            AwsError,
            zio.aws.mturk.model.ListWorkersWithQualificationTypeResponse.ReadOnly
          ] = proxy(ListWorkersWithQualificationTypePaginated, request)
          def createHIT(
              request: CreateHitRequest
          ): IO[AwsError, zio.aws.mturk.model.CreateHitResponse.ReadOnly] =
            proxy(CreateHIT, request)
          def sendBonus(
              request: SendBonusRequest
          ): IO[AwsError, zio.aws.mturk.model.SendBonusResponse.ReadOnly] =
            proxy(SendBonus, request)
          def updateExpirationForHIT(
              request: UpdateExpirationForHitRequest
          ): IO[
            AwsError,
            zio.aws.mturk.model.UpdateExpirationForHitResponse.ReadOnly
          ] = proxy(UpdateExpirationForHIT, request)
          def rejectAssignment(
              request: RejectAssignmentRequest
          ): IO[AwsError, ReadOnly] = proxy(RejectAssignment, request)
          def deleteQualificationType(
              request: DeleteQualificationTypeRequest
          ): IO[
            AwsError,
            zio.aws.mturk.model.DeleteQualificationTypeResponse.ReadOnly
          ] = proxy(DeleteQualificationType, request)
        }
      }
    }
    .toLayer
}
