package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class ApproveAssignmentRequest(
    assignmentId: EntityId,
    requesterFeedback: Option[String] = None,
    overrideRejection: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ApproveAssignmentRequest = {
    import ApproveAssignmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ApproveAssignmentRequest
      .builder()
      .assignmentId(EntityId.unwrap(assignmentId): java.lang.String)
      .optionallyWith(requesterFeedback.map(value => value: java.lang.String))(
        _.requesterFeedback
      )
      .optionallyWith(overrideRejection.map(value => value: java.lang.Boolean))(
        _.overrideRejection
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ApproveAssignmentRequest.ReadOnly =
    zio.aws.mturk.model.ApproveAssignmentRequest.wrap(buildAwsValue())
}
object ApproveAssignmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ApproveAssignmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ApproveAssignmentRequest =
      zio.aws.mturk.model.ApproveAssignmentRequest(
        assignmentId,
        requesterFeedback.map(value => value),
        overrideRejection.map(value => value)
      )
    def assignmentId: EntityId
    def requesterFeedback: Option[String]
    def overrideRejection: Option[Boolean]
    def getAssignmentId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(assignmentId)
    def getRequesterFeedback: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requesterFeedback", requesterFeedback)
    def getOverrideRejection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("overrideRejection", overrideRejection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ApproveAssignmentRequest
  ) extends zio.aws.mturk.model.ApproveAssignmentRequest.ReadOnly {
    override val assignmentId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.assignmentId())
    override val requesterFeedback: Option[String] =
      scala.Option(impl.requesterFeedback()).map(value => value: String)
    override val overrideRejection: Option[Boolean] =
      scala.Option(impl.overrideRejection()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ApproveAssignmentRequest
  ): zio.aws.mturk.model.ApproveAssignmentRequest.ReadOnly = new Wrapper(impl)
}
