package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{Timestamp, CustomerId, EntityId}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Assignment(
    assignmentId: Option[EntityId] = None,
    workerId: Option[CustomerId] = None,
    hitId: Option[EntityId] = None,
    assignmentStatus: Option[zio.aws.mturk.model.AssignmentStatus] = None,
    autoApprovalTime: Option[Timestamp] = None,
    acceptTime: Option[Timestamp] = None,
    submitTime: Option[Timestamp] = None,
    approvalTime: Option[Timestamp] = None,
    rejectionTime: Option[Timestamp] = None,
    deadline: Option[Timestamp] = None,
    answer: Option[String] = None,
    requesterFeedback: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.Assignment = {
    import Assignment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.Assignment
      .builder()
      .optionallyWith(
        assignmentId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.assignmentId)
      .optionallyWith(
        workerId.map(value => CustomerId.unwrap(value): java.lang.String)
      )(_.workerId)
      .optionallyWith(
        hitId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.hitId)
      .optionallyWith(assignmentStatus.map(value => value.unwrap))(
        _.assignmentStatus
      )
      .optionallyWith(
        autoApprovalTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.autoApprovalTime)
      .optionallyWith(
        acceptTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.acceptTime)
      .optionallyWith(
        submitTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTime)
      .optionallyWith(
        approvalTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.approvalTime)
      .optionallyWith(
        rejectionTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.rejectionTime)
      .optionallyWith(deadline.map(value => Timestamp.unwrap(value): Instant))(
        _.deadline
      )
      .optionallyWith(answer.map(value => value: java.lang.String))(_.answer)
      .optionallyWith(requesterFeedback.map(value => value: java.lang.String))(
        _.requesterFeedback
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.Assignment.ReadOnly =
    zio.aws.mturk.model.Assignment.wrap(buildAwsValue())
}
object Assignment {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mturk.model.Assignment] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.Assignment =
      zio.aws.mturk.model.Assignment(
        assignmentId.map(value => value),
        workerId.map(value => value),
        hitId.map(value => value),
        assignmentStatus.map(value => value),
        autoApprovalTime.map(value => value),
        acceptTime.map(value => value),
        submitTime.map(value => value),
        approvalTime.map(value => value),
        rejectionTime.map(value => value),
        deadline.map(value => value),
        answer.map(value => value),
        requesterFeedback.map(value => value)
      )
    def assignmentId: Option[EntityId]
    def workerId: Option[CustomerId]
    def hitId: Option[EntityId]
    def assignmentStatus: Option[zio.aws.mturk.model.AssignmentStatus]
    def autoApprovalTime: Option[Timestamp]
    def acceptTime: Option[Timestamp]
    def submitTime: Option[Timestamp]
    def approvalTime: Option[Timestamp]
    def rejectionTime: Option[Timestamp]
    def deadline: Option[Timestamp]
    def answer: Option[String]
    def requesterFeedback: Option[String]
    def getAssignmentId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("assignmentId", assignmentId)
    def getWorkerId: ZIO[Any, AwsError, CustomerId] =
      AwsError.unwrapOptionField("workerId", workerId)
    def getHitId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("hitId", hitId)
    def getAssignmentStatus
        : ZIO[Any, AwsError, zio.aws.mturk.model.AssignmentStatus] =
      AwsError.unwrapOptionField("assignmentStatus", assignmentStatus)
    def getAutoApprovalTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("autoApprovalTime", autoApprovalTime)
    def getAcceptTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("acceptTime", acceptTime)
    def getSubmitTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTime", submitTime)
    def getApprovalTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("approvalTime", approvalTime)
    def getRejectionTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("rejectionTime", rejectionTime)
    def getDeadline: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deadline", deadline)
    def getAnswer: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("answer", answer)
    def getRequesterFeedback: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requesterFeedback", requesterFeedback)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.Assignment
  ) extends zio.aws.mturk.model.Assignment.ReadOnly {
    override val assignmentId: Option[EntityId] = scala
      .Option(impl.assignmentId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val workerId: Option[CustomerId] = scala
      .Option(impl.workerId())
      .map(value => zio.aws.mturk.model.primitives.CustomerId(value))
    override val hitId: Option[EntityId] = scala
      .Option(impl.hitId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val assignmentStatus
        : Option[zio.aws.mturk.model.AssignmentStatus] = scala
      .Option(impl.assignmentStatus())
      .map(value => zio.aws.mturk.model.AssignmentStatus.wrap(value))
    override val autoApprovalTime: Option[Timestamp] = scala
      .Option(impl.autoApprovalTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val acceptTime: Option[Timestamp] = scala
      .Option(impl.acceptTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val submitTime: Option[Timestamp] = scala
      .Option(impl.submitTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val approvalTime: Option[Timestamp] = scala
      .Option(impl.approvalTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val rejectionTime: Option[Timestamp] = scala
      .Option(impl.rejectionTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val deadline: Option[Timestamp] = scala
      .Option(impl.deadline())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val answer: Option[String] =
      scala.Option(impl.answer()).map(value => value: String)
    override val requesterFeedback: Option[String] =
      scala.Option(impl.requesterFeedback()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.Assignment
  ): zio.aws.mturk.model.Assignment.ReadOnly = new Wrapper(impl)
}
