package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{
  EntityId,
  IdempotencyToken,
  CurrencyAmount,
  Integer
}
import scala.jdk.CollectionConverters._
final case class CreateHitRequest(
    maxAssignments: Option[Integer] = None,
    autoApprovalDelayInSeconds: Option[Long] = None,
    lifetimeInSeconds: Long,
    assignmentDurationInSeconds: Long,
    reward: CurrencyAmount,
    title: String,
    keywords: Option[String] = None,
    description: String,
    question: Option[String] = None,
    requesterAnnotation: Option[String] = None,
    qualificationRequirements: Option[
      Iterable[zio.aws.mturk.model.QualificationRequirement]
    ] = None,
    uniqueRequestToken: Option[IdempotencyToken] = None,
    assignmentReviewPolicy: Option[zio.aws.mturk.model.ReviewPolicy] = None,
    hitReviewPolicy: Option[zio.aws.mturk.model.ReviewPolicy] = None,
    hitLayoutId: Option[EntityId] = None,
    hitLayoutParameters: Option[
      Iterable[zio.aws.mturk.model.HITLayoutParameter]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.CreateHitRequest = {
    import CreateHitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.CreateHitRequest
      .builder()
      .optionallyWith(maxAssignments.map(value => value: java.lang.Integer))(
        _.maxAssignments
      )
      .optionallyWith(
        autoApprovalDelayInSeconds.map(value => value: java.lang.Long)
      )(_.autoApprovalDelayInSeconds)
      .lifetimeInSeconds(lifetimeInSeconds: java.lang.Long)
      .assignmentDurationInSeconds(assignmentDurationInSeconds: java.lang.Long)
      .reward(CurrencyAmount.unwrap(reward): java.lang.String)
      .title(title: java.lang.String)
      .optionallyWith(keywords.map(value => value: java.lang.String))(
        _.keywords
      )
      .description(description: java.lang.String)
      .optionallyWith(question.map(value => value: java.lang.String))(
        _.question
      )
      .optionallyWith(
        requesterAnnotation.map(value => value: java.lang.String)
      )(_.requesterAnnotation)
      .optionallyWith(
        qualificationRequirements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.qualificationRequirements)
      .optionallyWith(
        uniqueRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.uniqueRequestToken)
      .optionallyWith(
        assignmentReviewPolicy.map(value => value.buildAwsValue())
      )(_.assignmentReviewPolicy)
      .optionallyWith(hitReviewPolicy.map(value => value.buildAwsValue()))(
        _.hitReviewPolicy
      )
      .optionallyWith(
        hitLayoutId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.hitLayoutId)
      .optionallyWith(
        hitLayoutParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hitLayoutParameters)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.CreateHitRequest.ReadOnly =
    zio.aws.mturk.model.CreateHitRequest.wrap(buildAwsValue())
}
object CreateHitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.CreateHitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.CreateHitRequest =
      zio.aws.mturk.model.CreateHitRequest(
        maxAssignments.map(value => value),
        autoApprovalDelayInSeconds.map(value => value),
        lifetimeInSeconds,
        assignmentDurationInSeconds,
        reward,
        title,
        keywords.map(value => value),
        description,
        question.map(value => value),
        requesterAnnotation.map(value => value),
        qualificationRequirements.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        uniqueRequestToken.map(value => value),
        assignmentReviewPolicy.map(value => value.asEditable),
        hitReviewPolicy.map(value => value.asEditable),
        hitLayoutId.map(value => value),
        hitLayoutParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def maxAssignments: Option[Integer]
    def autoApprovalDelayInSeconds: Option[Long]
    def lifetimeInSeconds: Long
    def assignmentDurationInSeconds: Long
    def reward: CurrencyAmount
    def title: String
    def keywords: Option[String]
    def description: String
    def question: Option[String]
    def requesterAnnotation: Option[String]
    def qualificationRequirements
        : Option[List[zio.aws.mturk.model.QualificationRequirement.ReadOnly]]
    def uniqueRequestToken: Option[IdempotencyToken]
    def assignmentReviewPolicy
        : Option[zio.aws.mturk.model.ReviewPolicy.ReadOnly]
    def hitReviewPolicy: Option[zio.aws.mturk.model.ReviewPolicy.ReadOnly]
    def hitLayoutId: Option[EntityId]
    def hitLayoutParameters
        : Option[List[zio.aws.mturk.model.HITLayoutParameter.ReadOnly]]
    def getMaxAssignments: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxAssignments", maxAssignments)
    def getAutoApprovalDelayInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "autoApprovalDelayInSeconds",
        autoApprovalDelayInSeconds
      )
    def getLifetimeInSeconds: ZIO[Any, Nothing, Long] =
      ZIO.succeed(lifetimeInSeconds)
    def getAssignmentDurationInSeconds: ZIO[Any, Nothing, Long] =
      ZIO.succeed(assignmentDurationInSeconds)
    def getReward: ZIO[Any, Nothing, CurrencyAmount] = ZIO.succeed(reward)
    def getTitle: ZIO[Any, Nothing, String] = ZIO.succeed(title)
    def getKeywords: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keywords", keywords)
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getQuestion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("question", question)
    def getRequesterAnnotation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requesterAnnotation", requesterAnnotation)
    def getQualificationRequirements: ZIO[Any, AwsError, List[
      zio.aws.mturk.model.QualificationRequirement.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "qualificationRequirements",
      qualificationRequirements
    )
    def getUniqueRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("uniqueRequestToken", uniqueRequestToken)
    def getAssignmentReviewPolicy
        : ZIO[Any, AwsError, zio.aws.mturk.model.ReviewPolicy.ReadOnly] =
      AwsError.unwrapOptionField(
        "assignmentReviewPolicy",
        assignmentReviewPolicy
      )
    def getHitReviewPolicy
        : ZIO[Any, AwsError, zio.aws.mturk.model.ReviewPolicy.ReadOnly] =
      AwsError.unwrapOptionField("hitReviewPolicy", hitReviewPolicy)
    def getHitLayoutId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("hitLayoutId", hitLayoutId)
    def getHitLayoutParameters: ZIO[Any, AwsError, List[
      zio.aws.mturk.model.HITLayoutParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("hitLayoutParameters", hitLayoutParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.CreateHitRequest
  ) extends zio.aws.mturk.model.CreateHitRequest.ReadOnly {
    override val maxAssignments: Option[Integer] =
      scala.Option(impl.maxAssignments()).map(value => value: Integer)
    override val autoApprovalDelayInSeconds: Option[Long] =
      scala.Option(impl.autoApprovalDelayInSeconds()).map(value => value: Long)
    override val lifetimeInSeconds: Long = impl.lifetimeInSeconds(): Long
    override val assignmentDurationInSeconds: Long =
      impl.assignmentDurationInSeconds(): Long
    override val reward: CurrencyAmount =
      zio.aws.mturk.model.primitives.CurrencyAmount(impl.reward())
    override val title: String = impl.title(): String
    override val keywords: Option[String] =
      scala.Option(impl.keywords()).map(value => value: String)
    override val description: String = impl.description(): String
    override val question: Option[String] =
      scala.Option(impl.question()).map(value => value: String)
    override val requesterAnnotation: Option[String] =
      scala.Option(impl.requesterAnnotation()).map(value => value: String)
    override val qualificationRequirements
        : Option[List[zio.aws.mturk.model.QualificationRequirement.ReadOnly]] =
      scala
        .Option(impl.qualificationRequirements())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mturk.model.QualificationRequirement.wrap(item)
          }.toList
        )
    override val uniqueRequestToken: Option[IdempotencyToken] = scala
      .Option(impl.uniqueRequestToken())
      .map(value => zio.aws.mturk.model.primitives.IdempotencyToken(value))
    override val assignmentReviewPolicy
        : Option[zio.aws.mturk.model.ReviewPolicy.ReadOnly] = scala
      .Option(impl.assignmentReviewPolicy())
      .map(value => zio.aws.mturk.model.ReviewPolicy.wrap(value))
    override val hitReviewPolicy
        : Option[zio.aws.mturk.model.ReviewPolicy.ReadOnly] = scala
      .Option(impl.hitReviewPolicy())
      .map(value => zio.aws.mturk.model.ReviewPolicy.wrap(value))
    override val hitLayoutId: Option[EntityId] = scala
      .Option(impl.hitLayoutId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val hitLayoutParameters
        : Option[List[zio.aws.mturk.model.HITLayoutParameter.ReadOnly]] = scala
      .Option(impl.hitLayoutParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mturk.model.HITLayoutParameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.CreateHitRequest
  ): zio.aws.mturk.model.CreateHitRequest.ReadOnly = new Wrapper(impl)
}
