package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateHitResponse(
    hit: Option[zio.aws.mturk.model.HIT] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.CreateHitResponse = {
    import CreateHitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.CreateHitResponse
      .builder()
      .optionallyWith(hit.map(value => value.buildAwsValue()))(_.hit)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.CreateHitResponse.ReadOnly =
    zio.aws.mturk.model.CreateHitResponse.wrap(buildAwsValue())
}
object CreateHitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.CreateHitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.CreateHitResponse =
      zio.aws.mturk.model.CreateHitResponse(hit.map(value => value.asEditable))
    def hit: Option[zio.aws.mturk.model.HIT.ReadOnly]
    def getHit: ZIO[Any, AwsError, zio.aws.mturk.model.HIT.ReadOnly] =
      AwsError.unwrapOptionField("hit", hit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.CreateHitResponse
  ) extends zio.aws.mturk.model.CreateHitResponse.ReadOnly {
    override val hit: Option[zio.aws.mturk.model.HIT.ReadOnly] =
      scala.Option(impl.hit()).map(value => zio.aws.mturk.model.HIT.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.CreateHitResponse
  ): zio.aws.mturk.model.CreateHitResponse.ReadOnly = new Wrapper(impl)
}
