package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.CurrencyAmount
import scala.jdk.CollectionConverters._
final case class CreateHitTypeRequest(
    autoApprovalDelayInSeconds: Option[Long] = None,
    assignmentDurationInSeconds: Long,
    reward: CurrencyAmount,
    title: String,
    keywords: Option[String] = None,
    description: String,
    qualificationRequirements: Option[
      Iterable[zio.aws.mturk.model.QualificationRequirement]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.CreateHitTypeRequest = {
    import CreateHitTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.CreateHitTypeRequest
      .builder()
      .optionallyWith(
        autoApprovalDelayInSeconds.map(value => value: java.lang.Long)
      )(_.autoApprovalDelayInSeconds)
      .assignmentDurationInSeconds(assignmentDurationInSeconds: java.lang.Long)
      .reward(CurrencyAmount.unwrap(reward): java.lang.String)
      .title(title: java.lang.String)
      .optionallyWith(keywords.map(value => value: java.lang.String))(
        _.keywords
      )
      .description(description: java.lang.String)
      .optionallyWith(
        qualificationRequirements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.qualificationRequirements)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.CreateHitTypeRequest.ReadOnly =
    zio.aws.mturk.model.CreateHitTypeRequest.wrap(buildAwsValue())
}
object CreateHitTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.CreateHitTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.CreateHitTypeRequest =
      zio.aws.mturk.model.CreateHitTypeRequest(
        autoApprovalDelayInSeconds.map(value => value),
        assignmentDurationInSeconds,
        reward,
        title,
        keywords.map(value => value),
        description,
        qualificationRequirements.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def autoApprovalDelayInSeconds: Option[Long]
    def assignmentDurationInSeconds: Long
    def reward: CurrencyAmount
    def title: String
    def keywords: Option[String]
    def description: String
    def qualificationRequirements
        : Option[List[zio.aws.mturk.model.QualificationRequirement.ReadOnly]]
    def getAutoApprovalDelayInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "autoApprovalDelayInSeconds",
        autoApprovalDelayInSeconds
      )
    def getAssignmentDurationInSeconds: ZIO[Any, Nothing, Long] =
      ZIO.succeed(assignmentDurationInSeconds)
    def getReward: ZIO[Any, Nothing, CurrencyAmount] = ZIO.succeed(reward)
    def getTitle: ZIO[Any, Nothing, String] = ZIO.succeed(title)
    def getKeywords: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keywords", keywords)
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getQualificationRequirements: ZIO[Any, AwsError, List[
      zio.aws.mturk.model.QualificationRequirement.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "qualificationRequirements",
      qualificationRequirements
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.CreateHitTypeRequest
  ) extends zio.aws.mturk.model.CreateHitTypeRequest.ReadOnly {
    override val autoApprovalDelayInSeconds: Option[Long] =
      scala.Option(impl.autoApprovalDelayInSeconds()).map(value => value: Long)
    override val assignmentDurationInSeconds: Long =
      impl.assignmentDurationInSeconds(): Long
    override val reward: CurrencyAmount =
      zio.aws.mturk.model.primitives.CurrencyAmount(impl.reward())
    override val title: String = impl.title(): String
    override val keywords: Option[String] =
      scala.Option(impl.keywords()).map(value => value: String)
    override val description: String = impl.description(): String
    override val qualificationRequirements
        : Option[List[zio.aws.mturk.model.QualificationRequirement.ReadOnly]] =
      scala
        .Option(impl.qualificationRequirements())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mturk.model.QualificationRequirement.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.CreateHitTypeRequest
  ): zio.aws.mturk.model.CreateHitTypeRequest.ReadOnly = new Wrapper(impl)
}
