package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class CreateHitTypeResponse(hitTypeId: Option[EntityId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.CreateHitTypeResponse = {
    import CreateHitTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.CreateHitTypeResponse
      .builder()
      .optionallyWith(
        hitTypeId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.hitTypeId)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.CreateHitTypeResponse.ReadOnly =
    zio.aws.mturk.model.CreateHitTypeResponse.wrap(buildAwsValue())
}
object CreateHitTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.CreateHitTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.CreateHitTypeResponse =
      zio.aws.mturk.model.CreateHitTypeResponse(hitTypeId.map(value => value))
    def hitTypeId: Option[EntityId]
    def getHitTypeId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("hitTypeId", hitTypeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.CreateHitTypeResponse
  ) extends zio.aws.mturk.model.CreateHitTypeResponse.ReadOnly {
    override val hitTypeId: Option[EntityId] = scala
      .Option(impl.hitTypeId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.CreateHitTypeResponse
  ): zio.aws.mturk.model.CreateHitTypeResponse.ReadOnly = new Wrapper(impl)
}
