package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateHitWithHitTypeResponse(
    hit: Option[zio.aws.mturk.model.HIT] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeResponse = {
    import CreateHitWithHitTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeResponse
      .builder()
      .optionallyWith(hit.map(value => value.buildAwsValue()))(_.hit)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.CreateHitWithHitTypeResponse.ReadOnly =
    zio.aws.mturk.model.CreateHitWithHitTypeResponse.wrap(buildAwsValue())
}
object CreateHitWithHitTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.CreateHitWithHitTypeResponse =
      zio.aws.mturk.model
        .CreateHitWithHitTypeResponse(hit.map(value => value.asEditable))
    def hit: Option[zio.aws.mturk.model.HIT.ReadOnly]
    def getHit: ZIO[Any, AwsError, zio.aws.mturk.model.HIT.ReadOnly] =
      AwsError.unwrapOptionField("hit", hit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeResponse
  ) extends zio.aws.mturk.model.CreateHitWithHitTypeResponse.ReadOnly {
    override val hit: Option[zio.aws.mturk.model.HIT.ReadOnly] =
      scala.Option(impl.hit()).map(value => zio.aws.mturk.model.HIT.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeResponse
  ): zio.aws.mturk.model.CreateHitWithHitTypeResponse.ReadOnly = new Wrapper(
    impl
  )
}
