package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class CreateQualificationTypeRequest(
    name: String,
    keywords: Option[String] = None,
    description: String,
    qualificationTypeStatus: zio.aws.mturk.model.QualificationTypeStatus,
    retryDelayInSeconds: Option[Long] = None,
    test: Option[String] = None,
    answerKey: Option[String] = None,
    testDurationInSeconds: Option[Long] = None,
    autoGranted: Option[Boolean] = None,
    autoGrantedValue: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.CreateQualificationTypeRequest = {
    import CreateQualificationTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.CreateQualificationTypeRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(keywords.map(value => value: java.lang.String))(
        _.keywords
      )
      .description(description: java.lang.String)
      .qualificationTypeStatus(qualificationTypeStatus.unwrap)
      .optionallyWith(retryDelayInSeconds.map(value => value: java.lang.Long))(
        _.retryDelayInSeconds
      )
      .optionallyWith(test.map(value => value: java.lang.String))(_.test)
      .optionallyWith(answerKey.map(value => value: java.lang.String))(
        _.answerKey
      )
      .optionallyWith(
        testDurationInSeconds.map(value => value: java.lang.Long)
      )(_.testDurationInSeconds)
      .optionallyWith(autoGranted.map(value => value: java.lang.Boolean))(
        _.autoGranted
      )
      .optionallyWith(autoGrantedValue.map(value => value: java.lang.Integer))(
        _.autoGrantedValue
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.CreateQualificationTypeRequest.ReadOnly =
    zio.aws.mturk.model.CreateQualificationTypeRequest.wrap(buildAwsValue())
}
object CreateQualificationTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.CreateQualificationTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.CreateQualificationTypeRequest =
      zio.aws.mturk.model.CreateQualificationTypeRequest(
        name,
        keywords.map(value => value),
        description,
        qualificationTypeStatus,
        retryDelayInSeconds.map(value => value),
        test.map(value => value),
        answerKey.map(value => value),
        testDurationInSeconds.map(value => value),
        autoGranted.map(value => value),
        autoGrantedValue.map(value => value)
      )
    def name: String
    def keywords: Option[String]
    def description: String
    def qualificationTypeStatus: zio.aws.mturk.model.QualificationTypeStatus
    def retryDelayInSeconds: Option[Long]
    def test: Option[String]
    def answerKey: Option[String]
    def testDurationInSeconds: Option[Long]
    def autoGranted: Option[Boolean]
    def autoGrantedValue: Option[Integer]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getKeywords: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keywords", keywords)
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getQualificationTypeStatus
        : ZIO[Any, Nothing, zio.aws.mturk.model.QualificationTypeStatus] =
      ZIO.succeed(qualificationTypeStatus)
    def getRetryDelayInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("retryDelayInSeconds", retryDelayInSeconds)
    def getTest: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("test", test)
    def getAnswerKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("answerKey", answerKey)
    def getTestDurationInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("testDurationInSeconds", testDurationInSeconds)
    def getAutoGranted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoGranted", autoGranted)
    def getAutoGrantedValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("autoGrantedValue", autoGrantedValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.CreateQualificationTypeRequest
  ) extends zio.aws.mturk.model.CreateQualificationTypeRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val keywords: Option[String] =
      scala.Option(impl.keywords()).map(value => value: String)
    override val description: String = impl.description(): String
    override val qualificationTypeStatus
        : zio.aws.mturk.model.QualificationTypeStatus =
      zio.aws.mturk.model.QualificationTypeStatus
        .wrap(impl.qualificationTypeStatus())
    override val retryDelayInSeconds: Option[Long] =
      scala.Option(impl.retryDelayInSeconds()).map(value => value: Long)
    override val test: Option[String] =
      scala.Option(impl.test()).map(value => value: String)
    override val answerKey: Option[String] =
      scala.Option(impl.answerKey()).map(value => value: String)
    override val testDurationInSeconds: Option[Long] =
      scala.Option(impl.testDurationInSeconds()).map(value => value: Long)
    override val autoGranted: Option[Boolean] =
      scala.Option(impl.autoGranted()).map(value => value: Boolean)
    override val autoGrantedValue: Option[Integer] =
      scala.Option(impl.autoGrantedValue()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.CreateQualificationTypeRequest
  ): zio.aws.mturk.model.CreateQualificationTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
